/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class AsinCalculator
extends SeriesCalculator {
    public static final AsinCalculator INSTANCE = new AsinCalculator();
    private int n = 0;
    private BigRational factorial2n = BigRational.ONE;
    private BigRational factorialN = BigRational.ONE;
    private BigRational fourPowerN = BigRational.ONE;

    private AsinCalculator() {
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational factor = this.factorial2n.divide(this.fourPowerN.multiply(this.factorialN).multiply(this.factorialN).multiply(2 * this.n + 1));
        return factor;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.factorial2n = this.factorial2n.multiply(2 * this.n - 1).multiply(2 * this.n);
        this.factorialN = this.factorialN.multiply(this.n);
        this.fourPowerN = this.fourPowerN.multiply(4);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(x, mathContext);
    }
}

