/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.libdivide4j;

import java.io.Serializable;

public final class FastDivision {
    private FastDivision() {
    }

    public static long multiplyHighSigned(long x, long y) {
        long x_high = x >> 32;
        long x_low = x & 0xFFFFFFFFL;
        long y_high = y >> 32;
        long y_low = y & 0xFFFFFFFFL;
        long z2 = x_low * y_low;
        long t = x_high * y_low + (z2 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z0 = t >> 32;
        return x_high * y_high + z0 + ((z1 += x_low * y_high) >> 32);
    }

    public static long multiplyHighUnsigned(long x, long y) {
        long x_high = x >>> 32;
        long y_high = y >>> 32;
        long x_low = x & 0xFFFFFFFFL;
        long y_low = y & 0xFFFFFFFFL;
        long z2 = x_low * y_low;
        long t = x_high * y_low + (z2 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z0 = t >>> 32;
        return x_high * y_high + z0 + ((z1 += x_low * y_high) >>> 32);
    }

    public static long multiplyLow(long x, long y) {
        long n = x * y;
        return n;
    }

    public static long[] divideAndRemainder128(long u1, long u0, long v) {
        long un10;
        long un64;
        long b = 0x100000000L;
        if (u1 >= v) {
            return new long[]{-1L, -1L};
        }
        int s = Long.numberOfLeadingZeros(v);
        if (s > 0) {
            v <<= s;
            un64 = u1 << s | u0 >>> 64 - s & (long)(-s >> 31);
            un10 = u0 << s;
        } else {
            un64 = u1 | u0;
            un10 = u0;
        }
        long vn1 = v >>> 32;
        long vn0 = v & 0xFFFFFFFFL;
        long un1 = un10 >>> 32;
        long un0 = un10 & 0xFFFFFFFFL;
        long q1 = Long.divideUnsigned(un64, vn1);
        long rhat = un64 - q1 * vn1;
        while (Long.compareUnsigned(q1, b) >= 0 || Long.compareUnsigned(q1 * vn0, b * rhat + un1) > 0) {
            --q1;
            if (Long.compareUnsigned(rhat += vn1, b) < 0) continue;
        }
        long un21 = un64 * b + un1 - q1 * v;
        long q0 = Long.divideUnsigned(un21, vn1);
        rhat = un21 - q0 * vn1;
        while (Long.compareUnsigned(q0, b) >= 0 || Long.compareUnsigned(q0 * vn0, b * rhat + un0) > 0) {
            --q0;
            if (Long.compareUnsigned(rhat += vn1, b) < 0) continue;
        }
        long r = un21 * b + un0 - q0 * v >>> s;
        return new long[]{q1 * b + q0, r};
    }

    public static Magic magicUnsigned(long d) {
        return FastDivision.magicUnsigned(d, false);
    }

    public static Magic magicUnsigned(long d, boolean branchfree) {
        int resultMore;
        long resultMagic;
        if (d == 0L) {
            throw new ArithmeticException("divide by zero");
        }
        assert (!branchfree || d != 1L);
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(d);
        if ((d & d - 1L) == 0L) {
            if (!branchfree) {
                resultMagic = 0L;
                resultMore = floor_log_2_d | 0x80;
            } else {
                resultMagic = 0L;
                resultMore = floor_log_2_d - 1 | 0x40;
            }
        } else {
            int more;
            long[] tmp = FastDivision.divideAndRemainder128(1L << floor_log_2_d, 0L, d);
            long proposed_m = tmp[0];
            long rem = tmp[1];
            long e = d - rem;
            if (!branchfree && e < 1L << floor_log_2_d) {
                more = floor_log_2_d;
            } else {
                proposed_m += proposed_m;
                long twice_rem = rem + rem;
                if (twice_rem >= d || twice_rem < rem) {
                    ++proposed_m;
                }
                more = floor_log_2_d | 0x40;
            }
            resultMagic = 1L + proposed_m;
            resultMore = more;
        }
        return new Magic(resultMagic, resultMore, d);
    }

    public static long divideUnsignedFast(long dividend, Magic divider) {
        int more = divider.more;
        if ((more & 0x80) != 0) {
            return dividend >>> (more & 0x3F);
        }
        long q = FastDivision.multiplyHighUnsigned(divider.magic, dividend);
        if ((more & 0x40) != 0) {
            long t = (dividend - q >>> 1) + q;
            return t >>> (more & 0x3F);
        }
        return q >>> more;
    }

    public static Magic magicSigned(long d) {
        return FastDivision.magicSigned(d, false);
    }

    public static Magic magicSigned(long d, boolean branchfree) {
        int resultMore;
        long resultMagic;
        if (d == 0L) {
            throw new ArithmeticException("divide by zero");
        }
        assert (!branchfree || d != 1L && d != -1L);
        long ud = d;
        long absD = d < 0L ? -ud : ud;
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(absD);
        if ((absD & absD - 1L) == 0L) {
            resultMagic = 0L;
            resultMore = floor_log_2_d;
        } else {
            int more;
            long[] tmp = FastDivision.divideAndRemainder128(1L << floor_log_2_d - 1, 0L, absD);
            long proposed_m = tmp[0];
            long rem = tmp[1];
            long e = absD - rem;
            if (!branchfree && e < 1L << floor_log_2_d) {
                more = floor_log_2_d - 1;
            } else {
                proposed_m += proposed_m;
                long twice_rem = rem + rem;
                if (Long.compareUnsigned(twice_rem, absD) >= 0 || Long.compareUnsigned(twice_rem, rem) < 0) {
                    ++proposed_m;
                }
                more = floor_log_2_d | 0x40;
            }
            long magic = ++proposed_m;
            resultMore = more;
            resultMagic = magic;
        }
        return new Magic(resultMagic, resultMore, d);
    }

    public static long divideSignedFast(long dividend, Magic divider) {
        int more = divider.more;
        long magic = divider.magic;
        if (magic == 0L) {
            long uq;
            int shifter = more & 0x3F;
            long q = uq = dividend + (dividend >> 63 & (1L << shifter) - 1L);
            q >>= shifter;
            long shiftMask = more >> 7;
            q = (q ^ shiftMask) - shiftMask;
            return divider.divider < 0L ? -q : q;
        }
        long uq = FastDivision.multiplyHighSigned(magic, dividend);
        if ((more & 0x40) != 0) {
            long sign = more >>> 7;
            uq += (dividend ^ sign) - sign;
        }
        long q = uq;
        if ((q >>= more & 0x3F) < 0L) {
            ++q;
        }
        return divider.divider < 0L ? -q : q;
    }

    public static long remainderSignedFast(long dividend, Magic divider) {
        long quot = FastDivision.divideSignedFast(dividend, divider);
        return dividend - quot * divider.divider;
    }

    public static long remainderUnsignedFast(long dividend, Magic divider) {
        long quot = FastDivision.divideUnsignedFast(dividend, divider);
        return dividend - quot * divider.divider;
    }

    public static long floorDivideFast(long dividend, Magic divider) {
        long r = FastDivision.divideSignedFast(dividend, divider);
        if ((dividend ^ divider.divider) < 0L && r * divider.divider != dividend) {
            --r;
        }
        return r;
    }

    public static long modSignedFast(long dividend, Magic divider) {
        long div = FastDivision.divideSignedFast(dividend, divider);
        long m = dividend - div * divider.divider;
        if (m < 0L) {
            m += divider.divider;
        }
        return m;
    }

    public static long modUnsignedFast(long dividend, Magic divider) {
        return dividend - FastDivision.divideUnsignedFast(dividend, divider) * divider.divider;
    }

    public static Magic magic32ForMultiplyMod(long divider) {
        long v = divider;
        int s = Long.numberOfLeadingZeros(v);
        if (s > 0) {
            v <<= s;
        }
        return FastDivision.magicUnsigned(v >>> 32);
    }

    public static long multiplyMod128Unsigned(long a, long b, long divider, Magic magic32) {
        return FastDivision.multiplyMod128Unsigned0(FastDivision.multiplyHighUnsigned(a, b), FastDivision.multiplyLow(a, b), divider, magic32);
    }

    public static long multiplyMod128Unsigned0(long high, long low, long divider, Magic magic32) {
        long un10;
        long un64;
        long b = 0x100000000L;
        if (high >= divider) {
            throw new IllegalArgumentException();
        }
        int s = Long.numberOfLeadingZeros(divider);
        if (s > 0) {
            divider <<= s;
            un64 = high << s | low >>> 64 - s & (long)(-s >> 31);
            un10 = low << s;
        } else {
            un64 = high | low;
            un10 = low;
        }
        long vn1 = divider >>> 32;
        long vn0 = divider & 0xFFFFFFFFL;
        long un1 = un10 >>> 32;
        long un0 = un10 & 0xFFFFFFFFL;
        long q1 = FastDivision.divideUnsignedFast(un64, magic32);
        long rhat = un64 - q1 * vn1;
        while (Long.compareUnsigned(q1, b) >= 0 || Long.compareUnsigned(q1 * vn0, b * rhat + un1) > 0) {
            --q1;
            if (Long.compareUnsigned(rhat += vn1, b) < 0) continue;
        }
        long un21 = un64 * b + un1 - q1 * divider;
        long q0 = FastDivision.divideUnsignedFast(un21, magic32);
        rhat = un21 - q0 * vn1;
        while (Long.compareUnsigned(q0, b) >= 0 || Long.compareUnsigned(q0 * vn0, b * rhat + un0) > 0) {
            --q0;
            if (Long.compareUnsigned(rhat += vn1, b) < 0) continue;
        }
        long r = un21 * b + un0 - q0 * divider >>> s;
        return r;
    }

    public static final class Magic
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final long magic;
        public final int more;
        public final long divider;

        public Magic(long magic, int more, long divider) {
            this.magic = magic;
            this.more = more;
            this.divider = divider;
        }
    }
}

