/*
 * Decompiled with CFR 0.152.
 */
package ca.seinesoftware.hamcrest.path;

import ca.seinesoftware.hamcrest.path.Directory;
import ca.seinesoftware.hamcrest.path.Executable;
import ca.seinesoftware.hamcrest.path.Exists;
import ca.seinesoftware.hamcrest.path.Hidden;
import ca.seinesoftware.hamcrest.path.Readable;
import ca.seinesoftware.hamcrest.path.RegularFile;
import ca.seinesoftware.hamcrest.path.SameFile;
import ca.seinesoftware.hamcrest.path.SymbolicLink;
import ca.seinesoftware.hamcrest.path.Writable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public abstract class PathMatcher
extends TypeSafeMatcher<Path> {
    private static final LinkOption[] NO_OPTIONS = new LinkOption[0];
    protected final LinkOption[] linkOptions;

    protected PathMatcher(LinkOption ... options) {
        this.linkOptions = options;
    }

    protected PathMatcher() {
        this(NO_OPTIONS);
    }

    public void describeTo(Description description) {
        for (LinkOption option : this.linkOptions) {
            if (option != LinkOption.NOFOLLOW_LINKS) {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            description.appendText("a non-symbolic link to ");
        }
    }

    protected void describeMismatchSafely(Path path, Description description) {
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            description.appendValue((Object)path).appendText(" is a ");
            if (Files.isSymbolicLink(path)) {
                description.appendText("symbolic link to a ");
            }
            if (!Files.isReadable(path)) {
                description.appendText("un");
            }
            description.appendText("readable, ");
            if (!Files.isWritable(path)) {
                description.appendText("un");
            }
            description.appendText("writable, ");
            if (!Files.isExecutable(path)) {
                description.appendText("un");
            }
            description.appendText("executable");
            try {
                if (Files.isHidden(path)) {
                    description.appendText(", hidden");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                description.appendText(" directory");
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                description.appendText(" regular file");
            } else {
                description.appendText(" non-existent entry");
            }
        } else if (Files.notExists(path, this.linkOptions)) {
            description.appendValue((Object)path).appendText(" does not exist");
        } else {
            description.appendText("file system status for ").appendValue((Object)path).appendText(" cannot be determined");
        }
    }

    public static Matcher<Path> exists(LinkOption ... options) {
        return new Exists(options);
    }

    public static Matcher<Path> aDirectory(LinkOption ... options) {
        return new Directory(options);
    }

    public static Matcher<Path> aRegularFile(LinkOption ... options) {
        return new RegularFile(options);
    }

    public static Matcher<Path> aSymbolicLink() {
        return new SymbolicLink();
    }

    @Deprecated
    public static Matcher<Path> symbolicLink() {
        return new SymbolicLink();
    }

    public static Matcher<Path> readable() {
        return new Readable();
    }

    public static Matcher<Path> writable() {
        return new Writable();
    }

    public static Matcher<Path> executable() {
        return new Executable();
    }

    public static Matcher<Path> hidden() {
        return new Hidden();
    }

    public static Matcher<Path> sameFile(Path expected) {
        return new SameFile(expected);
    }
}

