/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.validator.FoundOnImplementsValidator;

public class ImplementationValidator
extends FoundOnImplementsValidator {
    public static final Set<String> METHODS_ALLOWED_TO_BE_PUBLIC = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"equals");

    public ImplementationValidator(RobolectricModel model, ProcessingEnvironment env) {
        super(model, env, "org.robolectric.annotation.Implementation");
    }

    @Override
    public Void visitExecutable(ExecutableElement elem, TypeElement parent) {
        Set<Modifier> modifiers = elem.getModifiers();
        if (!(METHODS_ALLOWED_TO_BE_PUBLIC.contains(elem.getSimpleName().toString()) || modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED))) {
            this.message(Diagnostic.Kind.ERROR, "@Implementation methods should be protected (preferred) or public (deprecated)");
        }
        return null;
    }
}

