/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public final class CheckMandatoryAuthentication
extends AbstractMessageHandler {
    @NonnullAfterInit
    private Function<MessageContext, Boolean> authenticationLookupStrategy;

    public void setAuthenticationLookupStrategy(@Nonnull Function<MessageContext, Boolean> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authenticationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message context authentication lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticationLookupStrategy == null) {
            throw new ComponentInitializationException("Message context authentication lookup strategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Boolean authenticated = (Boolean)this.authenticationLookupStrategy.apply((Object)messageContext);
        if (authenticated == null) {
            throw new MessageHandlerException("Message context did not contain any authentication state");
        }
        if (!authenticated.booleanValue()) {
            throw new MessageHandlerException("Message context was not authenticated");
        }
    }
}

