/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onlab.util.GeoLocation;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.TopologyEdge;

public class GeoDistanceLinkWeight
implements LinkWeigher {
    private static final double MAX_KM = 20037.5;
    private final DeviceService deviceService;

    public GeoDistanceLinkWeight(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public Weight getInitialWeight() {
        return ScalarWeight.toWeight((double)0.0);
    }

    public Weight getNonViableWeight() {
        return ScalarWeight.NON_VIABLE_WEIGHT;
    }

    public Weight weight(TopologyEdge edge) {
        GeoLocation src = this.getLocation(edge.link().src().deviceId());
        GeoLocation dst = this.getLocation(edge.link().dst().deviceId());
        return ScalarWeight.toWeight((double)(src != null && dst != null ? src.kilometersTo(dst) : 20037.5));
    }

    private GeoLocation getLocation(DeviceId deviceId) {
        Device d = this.deviceService.getDevice(deviceId);
        Annotations a = d != null ? d.annotations() : null;
        double latitude = this.getDouble(a, "latitude");
        double longitude = this.getDouble(a, "longitude");
        return latitude == Double.MAX_VALUE || longitude == Double.MAX_VALUE ? null : new GeoLocation(latitude, longitude);
    }

    private double getDouble(Annotations a, String key) {
        String value = a != null ? a.value(key) : null;
        try {
            return value != null ? Double.parseDouble(value) : Double.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            return Double.MAX_VALUE;
        }
    }
}

