/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.service;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.service.PiTranslatable;

@Beta
public final class PiTranslatedEntity<T extends PiTranslatable, E extends PiEntity> {
    private final T original;
    private final E translated;
    private final PiHandle<E> handle;

    public PiTranslatedEntity(T original, E translated, PiHandle<E> handle) {
        this.original = (PiTranslatable)Preconditions.checkNotNull(original);
        this.translated = (PiEntity)Preconditions.checkNotNull(translated);
        this.handle = (PiHandle)Preconditions.checkNotNull(handle);
    }

    public final PiEntityType entityType() {
        return this.translated.piEntityType();
    }

    public final T original() {
        return this.original;
    }

    public final E translated() {
        return this.translated;
    }

    public final PiHandle<E> handle() {
        return this.handle;
    }
}

