/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableEntry;

@Beta
public final class PiTableEntryHandle
extends PiHandle<PiTableEntry> {
    private final PiTableId tableId;
    private final PiMatchKey matchKey;

    private PiTableEntryHandle(DeviceId deviceId, PiTableId tableId, PiMatchKey matchKey) {
        super(deviceId);
        this.tableId = tableId;
        this.matchKey = matchKey;
    }

    public static PiTableEntryHandle of(DeviceId deviceId, PiTableId tableId, PiMatchKey matchKey) {
        Preconditions.checkNotNull((Object)tableId);
        Preconditions.checkNotNull((Object)matchKey);
        return new PiTableEntryHandle(deviceId, tableId, matchKey);
    }

    public static PiTableEntryHandle of(DeviceId deviceId, PiTableEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        return PiTableEntryHandle.of(deviceId, entry.table(), entry.matchKey());
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.TABLE_ENTRY;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.tableId, this.matchKey});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiTableEntryHandle other = (PiTableEntryHandle)obj;
        return Objects.equal((Object)this.deviceId(), (Object)other.deviceId()) && Objects.equal((Object)this.tableId, (Object)other.tableId) && Objects.equal((Object)this.matchKey, (Object)other.matchKey);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("tableId", (Object)this.tableId).add("matchKey", (Object)this.matchKey).toString();
    }
}

