/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiControlMetadataId;
import org.onosproject.net.pi.model.PiPacketOperationType;
import org.onosproject.net.pi.runtime.PiControlMetadata;

@Beta
public final class PiPacketOperation {
    private final DeviceId deviceId;
    private final ImmutableByteSequence data;
    private final Set<PiControlMetadata> packetMetadatas;
    private final PiPacketOperationType type;

    private PiPacketOperation(DeviceId deviceId, ImmutableByteSequence data, Collection<PiControlMetadata> packetMetadatas, PiPacketOperationType type) {
        this.deviceId = deviceId;
        this.data = data;
        this.packetMetadatas = ImmutableSet.copyOf(packetMetadatas);
        this.type = type;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public PiPacketOperationType type() {
        return this.type;
    }

    public ImmutableByteSequence data() {
        return this.data;
    }

    public Collection<PiControlMetadata> metadatas() {
        return this.packetMetadatas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiPacketOperation that = (PiPacketOperation)o;
        return Objects.equal(this.packetMetadatas, that.packetMetadatas) && Objects.equal((Object)this.deviceId, (Object)that.deviceId) && Objects.equal((Object)this.data, (Object)that.data()) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId, this.data, this.packetMetadatas, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId).addValue((Object)this.type.toString()).addValue(this.packetMetadatas).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceId deviceId;
        private Map<PiControlMetadataId, PiControlMetadata> packetMetadatas = new HashMap<PiControlMetadataId, PiControlMetadata>();
        private PiPacketOperationType type;
        private ImmutableByteSequence data;

        private Builder() {
        }

        public Builder forDevice(DeviceId deviceId) {
            Preconditions.checkNotNull((Object)deviceId);
            this.deviceId = deviceId;
            return this;
        }

        public Builder withData(ImmutableByteSequence data) {
            Preconditions.checkNotNull((Object)data);
            this.data = data;
            return this;
        }

        public Builder withMetadata(PiControlMetadata metadata) {
            Preconditions.checkNotNull((Object)metadata);
            this.packetMetadatas.put(metadata.id(), metadata);
            return this;
        }

        public Builder withMetadatas(Collection<PiControlMetadata> metadatas) {
            Preconditions.checkNotNull(metadatas);
            metadatas.forEach(this::withMetadata);
            return this;
        }

        public Builder withType(PiPacketOperationType type) {
            this.type = type;
            return this;
        }

        public PiPacketOperation build() {
            Preconditions.checkNotNull((Object)this.deviceId);
            Preconditions.checkNotNull((Object)this.data);
            Preconditions.checkNotNull(this.packetMetadatas);
            Preconditions.checkNotNull((Object)((Object)this.type));
            return new PiPacketOperation(this.deviceId, this.data, this.packetMetadatas.values(), this.type);
        }
    }
}

