/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.onosproject.net.AnnotationKeys;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.ResourceContext;

@Beta
public class LatencyConstraint
implements Constraint {
    private final Duration latency;

    public LatencyConstraint(Duration latency) {
        this.latency = latency;
    }

    private LatencyConstraint() {
        this.latency = Duration.ZERO;
    }

    public Duration latency() {
        return this.latency;
    }

    @Override
    public double cost(Link link, ResourceContext context) {
        return this.cost(link);
    }

    private double cost(Link link) {
        if (link.type() != Link.Type.EDGE) {
            return link.annotations().value("latency") != null ? AnnotationKeys.getAnnotatedValue(link, "latency") : 0.0;
        }
        return 0.0;
    }

    @Override
    public boolean validate(Path path, ResourceContext context) {
        return this.validate(path);
    }

    private boolean validate(Path path) {
        double pathLatency = path.links().stream().mapToDouble(this::cost).sum();
        return Duration.of((long)pathLatency, ChronoUnit.NANOS).compareTo(this.latency) <= 0;
    }

    public int hashCode() {
        return this.latency.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LatencyConstraint)) {
            return false;
        }
        LatencyConstraint that = (LatencyConstraint)obj;
        return Objects.equals(this.latency, that.latency);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("latency", (Object)this.latency).toString();
    }
}

