/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class Icmpv6CodeCriterion
implements Criterion {
    private static final short MASK = 255;
    private final short icmpv6Code;

    Icmpv6CodeCriterion(short icmpv6Code) {
        this.icmpv6Code = (short)(icmpv6Code & 0xFF);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.ICMPV6_CODE;
    }

    public short icmpv6Code() {
        return this.icmpv6Code;
    }

    public String toString() {
        return this.type().toString() + ":" + this.icmpv6Code;
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.icmpv6Code);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Icmpv6CodeCriterion) {
            Icmpv6CodeCriterion that = (Icmpv6CodeCriterion)obj;
            return Objects.equals(this.icmpv6Code, that.icmpv6Code) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

