/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLongs;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PortNumber {
    public static final PortNumber P0 = PortNumber.portNumber(0L);
    static final long MAX_NUMBER = 0xFFFFFFFFL;
    static final long IN_PORT_NUMBER = -8L;
    static final long TABLE_NUMBER = -7L;
    static final long NORMAL_NUMBER = -6L;
    static final long FLOOD_NUMBER = -5L;
    static final long ALL_NUMBER = -4L;
    static final long CONTROLLER_NUMBER = -3L;
    static final long LOCAL_NUMBER = -2L;
    static final long ANY_NUMBER = -1L;
    public static final PortNumber IN_PORT = new PortNumber(-8L);
    public static final PortNumber TABLE = new PortNumber(-7L);
    public static final PortNumber NORMAL = new PortNumber(-6L);
    public static final PortNumber FLOOD = new PortNumber(-5L);
    public static final PortNumber ALL = new PortNumber(-4L);
    public static final PortNumber LOCAL = new PortNumber(-2L);
    public static final PortNumber CONTROLLER = new PortNumber(-3L);
    public static final PortNumber ANY = new PortNumber(-1L);
    static final Supplier<Map<Long, Logical>> LOGICAL = Suppliers.memoize(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Logical lp : Logical.values()) {
            builder.put((Object)lp.number(), (Object)lp);
        }
        return builder.build();
    });
    private final long number;
    private final String name;
    private final boolean hasName;
    private static final Pattern NAMED = Pattern.compile("^\\[(?<name>.*)\\]\\((?<num>\\d+)\\)$");

    private PortNumber(long number) {
        this.number = number;
        this.name = UnsignedLongs.toString((long)number);
        this.hasName = false;
    }

    private PortNumber(long number, String name) {
        this.number = number;
        this.name = name;
        this.hasName = true;
    }

    public static PortNumber portNumber(long number) {
        return new PortNumber(number);
    }

    public static PortNumber portNumber(String string) {
        return new PortNumber(UnsignedLongs.decode((String)string));
    }

    public static PortNumber portNumber(long number, String name) {
        return new PortNumber(number, name);
    }

    public static PortNumber fromString(String s) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkArgument((!s.isEmpty() ? 1 : 0) != 0, (Object)"cannot be empty");
        if (PortNumber.isAsciiDecimal(s.charAt(0))) {
            return PortNumber.portNumber(s);
        }
        if (s.startsWith("[")) {
            Matcher matcher = NAMED.matcher(s);
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid named PortNumber %s", (Object)s);
            String name = matcher.group("name");
            String num = matcher.group("num");
            return PortNumber.portNumber(UnsignedLongs.parseUnsignedLong((String)num), name);
        }
        if (s.startsWith("UNKNOWN(") && s.endsWith(")")) {
            return PortNumber.portNumber(s.substring("UNKNOWN(".length(), s.length() - 1));
        }
        return Logical.valueOf(s).instance;
    }

    public boolean isLogical() {
        if (this.hasName) {
            return false;
        }
        return this.number < 0L || this.number > 0xFFFFFFFFL;
    }

    public long toLong() {
        return this.number;
    }

    public String name() {
        return this.name;
    }

    public boolean hasName() {
        return this.hasName;
    }

    private String decodeLogicalPort() {
        Logical logical = (Logical)((Object)((Map)LOGICAL.get()).get(this.number));
        if (logical != null) {
            return logical.toString();
        }
        return String.format("UNKNOWN(%s)", UnsignedLongs.toString((long)this.number));
    }

    private static boolean isAsciiDecimal(char c) {
        return '0' <= c && c <= '9';
    }

    public String toString() {
        if (this.isLogical()) {
            return this.decodeLogicalPort();
        }
        if (this.hasName()) {
            return String.format("[%s](%d)", this.name, this.number);
        }
        return this.name;
    }

    public int hashCode() {
        return Long.hashCode(this.number);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PortNumber) {
            PortNumber other = (PortNumber)obj;
            return this.number == other.number;
        }
        return false;
    }

    public boolean exactlyEquals(PortNumber that) {
        if (this == that) {
            return true;
        }
        return this.equals(that) && this.hasName == that.hasName && Objects.equal((Object)this.name, (Object)that.name);
    }

    public static enum Logical {
        IN_PORT(-8L),
        TABLE(-7L),
        NORMAL(-6L),
        FLOOD(-5L),
        ALL(-4L),
        LOCAL(-2L),
        CONTROLLER(-3L),
        ANY(-1L);

        private final long number;
        private final PortNumber instance;

        public long number() {
            return this.number;
        }

        public PortNumber instance() {
            return this.instance;
        }

        private Logical(long number) {
            this.number = number;
            this.instance = new PortNumber(number);
        }
    }
}

