/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;

public class RestartContainerCmdImpl
extends AbstrDockerCmd<RestartContainerCmd, Void>
implements RestartContainerCmd {
    private String containerId;
    private int timeout = 10;

    public RestartContainerCmdImpl(RestartContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public RestartContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public RestartContainerCmd withtTimeout(int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout must be greater or equal 0");
        this.timeout = timeout;
        return this;
    }

    public String toString() {
        return "restart " + ("--time=" + this.timeout + " ") + this.containerId;
    }

    @Override
    public Void exec() throws NotFoundException {
        return (Void)super.exec();
    }
}

