/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen.function;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.kurento.modulecreator.definition.Return;
import org.kurento.modulecreator.definition.Type;
import org.kurento.modulecreator.definition.TypeRef;

public class JavaObjectType
implements TemplateMethodModelEx {
    public Object exec(List arguments) throws TemplateModelException {
        Object type = arguments.get(0);
        if (type instanceof StringModel && (type = ((StringModel)type).getWrappedObject()) instanceof Return) {
            type = ((Return)type).getType();
        }
        boolean asObject = true;
        if (arguments.size() > 1) {
            asObject = ((TemplateBooleanModel)arguments.get(1)).getAsBoolean();
        }
        if (type == null) {
            if (asObject) {
                return "Void";
            }
            return "void";
        }
        if (type instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)type;
            if (typeRef.isList()) {
                return "java.util.List<" + this.getTypeAsString(typeRef.getType(), true) + ">";
            }
            if (typeRef.isMap()) {
                return "java.util.Map<String," + this.getTypeAsString(typeRef.getType(), true) + ">";
            }
            return this.getTypeAsString(typeRef.getType(), asObject);
        }
        if (type instanceof Type) {
            return this.getTypeAsString((Type)type, asObject);
        }
        if (type instanceof String) {
            return this.getTypeAsString((String)type, asObject);
        }
        return type;
    }

    private String getTypeAsString(Type type, boolean asObject) {
        String typeName = type.getName();
        String typeAsString = this.getTypeAsString(typeName, asObject);
        if (typeAsString != null) {
            return typeAsString;
        }
        return type.getModule().getCode().getApi().get("java").get("packageName") + "." + typeName;
    }

    private String getTypeAsString(String typeName, boolean asObject) {
        if (asObject) {
            if (typeName.equals("int")) {
                return "Integer";
            }
            if (typeName.equals("float")) {
                return "Float";
            }
            if (typeName.equals("boolean")) {
                return "Boolean";
            }
            if (typeName.equals("double")) {
                return "Double";
            }
            if (typeName.equals("int64")) {
                return "Long";
            }
        } else {
            if (typeName.equals("int") || typeName.equals("float") || typeName.equals("boolean") || typeName.equals("double")) {
                return typeName;
            }
            if (typeName.equals("int64")) {
                return "long";
            }
        }
        if (typeName.equals("String")) {
            return typeName;
        }
        return null;
    }
}

