/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kurento.modulecreator.definition.ModuleDefinition;

public class ModuleManager {
    private final Map<String, ModuleDefinition> modules = new HashMap<String, ModuleDefinition>();
    private ModuleManager dependencies;

    public void resolveModules() {
        for (ModuleDefinition module : this.modules.values()) {
            module.resolveModule(this);
        }
    }

    public ModuleDefinition getModule(String name) {
        ModuleDefinition module = this.modules.get(name);
        if (module != null) {
            return module;
        }
        if (this.dependencies != null) {
            return this.dependencies.getModule(name);
        }
        return null;
    }

    public ModuleDefinition getModule(String name, String version) {
        ModuleDefinition module = this.modules.get(name);
        if (module != null) {
            if (module.getVersion().equals(version)) {
                return module;
            }
        } else if (this.dependencies != null) {
            return this.dependencies.getModule(name, version);
        }
        return null;
    }

    private void removeModule(String name) {
        ModuleDefinition module = this.modules.get(name);
        if (module != null) {
            this.modules.remove(module.getName());
        }
        if (this.dependencies != null) {
            this.dependencies.removeModule(name);
        }
    }

    public void setDependencies(ModuleManager dependencies) {
        this.dependencies = dependencies;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (ModuleDefinition module : dependencies.getModules()) {
            if (this.modules.get(module.getName()) == null) continue;
            toRemove.add(module.getName());
        }
        for (String name : toRemove) {
            this.dependencies.removeModule(name);
        }
    }

    public Collection<ModuleDefinition> getModules() {
        return this.modules.values();
    }

    public void addModules(List<ModuleDefinition> modules) {
        for (ModuleDefinition module : modules) {
            module.validateModule();
            this.addModule(module);
        }
    }

    public void addModule(ModuleDefinition module) {
        this.modules.put(module.getName(), module);
    }

    public void addModuleInSeveralKmdFiles(List<ModuleDefinition> modules) {
        ModuleDefinition module = modules.get(0);
        for (int i = 1; i < modules.size(); ++i) {
            module.fusionModules(modules.get(i));
        }
        this.addModule(module);
    }
}

