/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kurento.modulecreator.KurentoModuleCreatorException;
import org.kurento.modulecreator.ModuleManager;
import org.kurento.modulecreator.PathUtils;
import org.kurento.modulecreator.Result;
import org.kurento.modulecreator.codegen.CodeGen;
import org.kurento.modulecreator.codegen.Error;
import org.kurento.modulecreator.definition.ComplexType;
import org.kurento.modulecreator.definition.Event;
import org.kurento.modulecreator.definition.Import;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.json.JsonModuleSaverLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoModuleCreator {
    private static final Logger log = LoggerFactory.getLogger(KurentoModuleCreator.class);
    private static final String CONFIG_FILE_NAME = "config.json";
    private Path codegenDir;
    private JsonObject config = new JsonObject();
    private Path templatesDir;
    private boolean verbose;
    private boolean deleteGenDir;
    private boolean overwrite;
    private List<Path> dependencyKmdFiles = new ArrayList<Path>();
    private List<Path> dependencyKmdFilesToGen = new ArrayList<Path>();
    private List<Path> kmdFilesToGen = new ArrayList<Path>();
    private boolean listGeneratedFiles = false;
    private String internalTemplates = null;
    private Path outputModuleFile = null;
    private boolean hasToGenerateCode = true;
    private ModuleManager moduleManager;
    private ModuleManager depModuleManager;
    private boolean generateMavenPom = false;
    private boolean generateNpmPackage = false;

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public ModuleManager getDepModuleManager() {
        return this.depModuleManager;
    }

    public void setInternalTemplates(String internalTemplates) {
        this.internalTemplates = internalTemplates;
    }

    public String getInternalTemplates() {
        return this.internalTemplates;
    }

    public void setKmdFilesToGen(List<Path> kmdFiles) {
        this.kmdFilesToGen = kmdFiles;
    }

    public void addKmdFileToGen(Path kmdFile) {
        this.kmdFilesToGen.add(kmdFile);
    }

    public void setDependencyKmdFilesToGen(List<Path> dependencyFilesToGen) {
        this.dependencyKmdFilesToGen = dependencyFilesToGen;
    }

    public void addDependencyKmdFileToGen(Path kmdFile) {
        this.dependencyKmdFilesToGen.add(kmdFile);
    }

    public void setConfig(JsonObject config) {
        this.config = config;
    }

    public void setCodeGenDir(Path codegenDir) {
        this.codegenDir = codegenDir;
    }

    public void setTemplatesDir(Path templatesDir) {
        this.templatesDir = templatesDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDeleteGenDir(boolean deleteGenDir) {
        this.deleteGenDir = deleteGenDir;
    }

    public void setDependencyKmdFiles(List<Path> dependencyKmdFiles) {
        this.dependencyKmdFiles = dependencyKmdFiles;
    }

    public void addDependencyKmdFile(Path dependencyKmdFile) {
        this.dependencyKmdFiles.add(dependencyKmdFile);
    }

    public void setListGeneratedFiles(boolean listGeneratedFiles) {
        this.listGeneratedFiles = listGeneratedFiles;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean hasToGenerateCode() {
        return this.hasToGenerateCode;
    }

    private Path getInternalTemplatesDir(String internalTemplates) throws IOException {
        URL internalTemplatesAsURL = this.getClass().getResource("/" + internalTemplates);
        if (internalTemplatesAsURL != null) {
            try {
                return PathUtils.getPathInClasspath(internalTemplatesAsURL);
            }
            catch (URISyntaxException e) {
                throw new KurentoModuleCreatorException("Error trying to load internal templates folder '" + internalTemplates + "'", e);
            }
        }
        throw new KurentoModuleCreatorException("The internal templates folder '" + internalTemplates + "' doesn't exist");
    }

    public Result generateCode() throws JsonIOException, IOException {
        Path configFile;
        if (this.moduleManager == null) {
            this.loadModulesFromKmdFiles();
        }
        if (this.internalTemplates != null) {
            this.templatesDir = this.getInternalTemplatesDir(this.internalTemplates);
        }
        if (this.templatesDir != null && Files.exists(configFile = this.templatesDir.resolve(CONFIG_FILE_NAME), new LinkOption[0])) {
            JsonObject internalConfig = KurentoModuleCreator.loadConfigFile(configFile);
            KurentoModuleCreator.overrideConfig(internalConfig, this.config);
            this.config = internalConfig;
        }
        try {
            if (this.deleteGenDir) {
                PathUtils.delete(this.codegenDir, this.loadNoDeleteFiles(this.config));
            }
            if (this.codegenDir != null && !Files.exists(this.codegenDir, new LinkOption[0])) {
                Files.createDirectories(this.codegenDir, new FileAttribute[0]);
            }
            CodeGen codeGen = new CodeGen(this.templatesDir, this.codegenDir, this.verbose, this.listGeneratedFiles, this.overwrite, this.config);
            for (ModuleDefinition module : this.moduleManager.getModules()) {
                if (this.config.has("expandMethodsWithOpsParams") && this.config.get("expandMethodsWithOpsParams").getAsBoolean()) {
                    module.expandMethodsWithOpsParams();
                }
                if (this.templatesDir != null && this.codegenDir != null) {
                    codeGen.generateCode(module);
                }
                if (this.outputModuleFile != null) {
                    JsonModuleSaverLoader.getInstance().writeToFile(module, new File(this.outputModuleFile.toFile(), module.getName() + ".kmd.json"));
                }
                if (this.generateMavenPom) {
                    codeGen.setTemplatesDir(this.getInternalTemplatesDir("maven"));
                    codeGen.generateMavenPom(module, this.searchFiles(this.kmdFilesToGen, "pom.xml"));
                }
                if (!this.generateNpmPackage) continue;
                codeGen.setTemplatesDir(this.getInternalTemplatesDir("npm"));
                codeGen.generateNpmPackage(module, this.searchFiles(this.kmdFilesToGen, "package.json"), this.searchFiles(this.kmdFilesToGen, "bower.json"));
            }
            return new Result();
        }
        catch (KurentoModuleCreatorException e) {
            return new Result(new Error("Error: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Result(new Error("Unexpected error: " + e.getClass().getName() + " " + e.getMessage()));
        }
    }

    private Path searchFiles(List<Path> kmdFiles, String fileName) throws IOException {
        ArrayList<Path> pomFiles = new ArrayList<Path>();
        for (Path kmdFile : kmdFiles) {
            pomFiles.addAll(PathUtils.searchFiles(kmdFile.getParent(), fileName));
        }
        if (pomFiles.isEmpty()) {
            return null;
        }
        if (pomFiles.size() > 1) {
            log.warn("There are several '" + fileName + "' files in kmd.json folders." + " Picking the first one");
        }
        return (Path)pomFiles.get(0);
    }

    private List<String> loadNoDeleteFiles(JsonObject configContent) {
        JsonArray array;
        ArrayList<String> noDeleteFiles = new ArrayList<String>();
        if (configContent != null && (array = configContent.getAsJsonArray("no_delete")) != null) {
            for (JsonElement elem : array) {
                if (!(elem instanceof JsonPrimitive)) continue;
                noDeleteFiles.add(((JsonPrimitive)elem).getAsString());
            }
        }
        return noDeleteFiles;
    }

    public static JsonObject loadConfigFile(Path configFile) throws JsonIOException, IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            JsonElement element = (JsonElement)gson.fromJson((Reader)Files.newBufferedReader(configFile, Charset.forName("UTF-8")), JsonElement.class);
            return element.getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new KurentoModuleCreatorException("Config file '" + configFile + "' has the following formatting error:" + e.getLocalizedMessage());
        }
    }

    private static void overrideConfig(JsonObject configContents, JsonObject newConfigContents) {
        for (Map.Entry e : newConfigContents.entrySet()) {
            configContents.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    public void loadModulesFromKmdFiles() throws FileNotFoundException, IOException {
        log.debug("Loading dependencies");
        this.depModuleManager = new ModuleManager();
        this.depModuleManager.addModules(this.loadModuleDescriptors(this.dependencyKmdFiles));
        this.depModuleManager.resolveModules();
        ModuleDefinition module = this.fusionModuleDescriptors(this.loadModuleDescriptors(this.kmdFilesToGen));
        if (module != null) {
            module.validateModule();
        }
        log.debug("Loading dependency kmd files to generate code");
        this.moduleManager = new ModuleManager();
        this.moduleManager.addModules(this.loadModuleDescriptors(this.dependencyKmdFilesToGen));
        if (module != null) {
            this.moduleManager.addModule(module);
        }
        this.moduleManager.setDependencies(this.depModuleManager);
        this.moduleManager.resolveModules();
        this.hasToGenerateCode = module != null && !module.hasKmdSection() || !this.dependencyKmdFilesToGen.isEmpty();
    }

    private ModuleDefinition fusionModuleDescriptors(List<ModuleDefinition> modules) {
        if (modules.isEmpty()) {
            return null;
        }
        ModuleDefinition module = modules.get(0);
        for (int i = 1; i < modules.size(); ++i) {
            module.fusionModules(modules.get(i));
        }
        return module;
    }

    private List<ModuleDefinition> loadModuleDescriptors(List<Path> kmdFiles) throws FileNotFoundException, IOException {
        ArrayList<ModuleDefinition> modules = new ArrayList<ModuleDefinition>();
        for (Path kmdFile : kmdFiles) {
            log.debug("Loading kmdFile " + kmdFile);
            ModuleDefinition module = JsonModuleSaverLoader.getInstance().loadFromFile(kmdFile);
            modules.add(module);
        }
        return modules;
    }

    public void printValues(String[] keys) throws FileNotFoundException, IOException {
        if (this.moduleManager == null) {
            this.loadModulesFromKmdFiles();
        }
        for (ModuleDefinition module : this.moduleManager.getModules()) {
            for (String key : keys) {
                System.out.println("Value: " + key + " = " + KurentoModuleCreator.getValue(module, key));
            }
        }
    }

    public void printSimpleKmd() throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        if (this.moduleManager == null) {
            this.loadModulesFromKmdFiles();
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (ModuleDefinition module : this.moduleManager.getModules()) {
            for (RemoteClass klass : module.getRemoteClasses()) {
                System.out.println("RemoteClass:\t" + klass.getName());
                digest.update(klass.getName().getBytes());
            }
            for (Event event : module.getEvents()) {
                System.out.println("Event:\t" + event.getName());
                digest.update(event.getName().getBytes());
            }
            for (ComplexType complexType : module.getComplexTypes()) {
                System.out.println("ComplexType:\t" + complexType.getName());
                digest.update(complexType.getName().getBytes());
            }
            for (Import dep : module.getImports()) {
                String depDesc = dep.getName() + " " + dep.getVersion();
                System.out.println("Dep: " + depDesc);
                digest.update(depDesc.getBytes());
            }
        }
        System.out.print("Digest: ");
        for (byte b : digest.digest()) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() < 1) {
                s = "00";
            } else if (s.length() < 2) {
                s = "0" + s;
            }
            System.out.print(s);
        }
        System.out.println("");
    }

    private static String getValue(Object object, String key) {
        Object value;
        int index = key.indexOf(46);
        String currentKey = index == -1 ? key : key.substring(0, index);
        if (object instanceof Map) {
            value = ((Map)object).get(key);
            if (value != null) {
                return "" + value;
            }
            value = ((Map)object).get(currentKey);
        } else if (object instanceof List) {
            value = ((List)object).get(Integer.valueOf(currentKey));
        } else {
            try {
                Method method = object.getClass().getMethod("get" + Character.toUpperCase(currentKey.charAt(0)) + currentKey.substring(1), new Class[0]);
                value = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                try {
                    Method method = object.getClass().getMethod(currentKey, new Class[0]);
                    value = method.invoke(object, new Object[0]);
                }
                catch (Exception ex) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        if (index == -1) {
            return "" + value;
        }
        String nextStep = key.substring(index + 1);
        return KurentoModuleCreator.getValue(value, nextStep);
    }

    public void setOutputFile(Path outputModuleFile) {
        this.outputModuleFile = outputModuleFile;
    }

    public void setGenerateMavenPom(boolean hasOption) {
        this.generateMavenPom = hasOption;
    }

    public void setGenerateNpmPackage(boolean hasOption) {
        this.generateNpmPackage = hasOption;
    }
}

