/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.extractor.Extractor;
import org.apache.jmeter.extractor.JSoupExtractor;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HtmlExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    public static final String EXTRACTOR_JSOUP = "JSOUP";
    public static final String EXTRACTOR_JODD = "JODD";
    public static final String DEFAULT_EXTRACTOR = "";
    private static final long serialVersionUID = 3978073849365558131L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String EXPRESSION = "HtmlExtractor.expr";
    private static final String ATTRIBUTE = "HtmlExtractor.attribute";
    private static final String REFNAME = "HtmlExtractor.refname";
    private static final String MATCH_NUMBER = "HtmlExtractor.match_number";
    private static final String DEFAULT = "HtmlExtractor.default";
    private static final String EXTRACTOR_IMPL = "HtmlExtractor.extractor_impl";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String UNDERSCORE = "_";
    private Extractor extractor;

    public static String[] getImplementations() {
        return new String[]{EXTRACTOR_JSOUP, EXTRACTOR_JODD};
    }

    public void process() {
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        log.debug("HtmlExtractor processing result");
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        String expression = this.getExpression();
        String attribute = this.getAttribute();
        int matchNumber = this.getMatchNumber();
        String defaultValue = this.getDefaultValue();
        if (defaultValue.length() > 0) {
            vars.put(refName, defaultValue);
        }
        try {
            List<String> matches = this.extractMatchingStrings(vars, expression, attribute, matchNumber, previousResult);
            int prevCount = 0;
            String prevString = vars.get(refName + REF_MATCH_NR);
            if (prevString != null) {
                vars.remove(refName + REF_MATCH_NR);
                try {
                    prevCount = Integer.parseInt(prevString);
                }
                catch (NumberFormatException e1) {
                    log.warn("Could not parse " + prevString + " " + e1);
                }
            }
            int matchCount = 0;
            try {
                String refName_n;
                int i;
                String match;
                if (matchNumber >= 0) {
                    match = this.getCorrectMatch(matches, matchNumber);
                    if (match != null) {
                        vars.put(refName, match);
                    }
                } else {
                    matchCount = matches.size();
                    vars.put(refName + REF_MATCH_NR, Integer.toString(matchCount));
                    for (i = 1; i <= matchCount; ++i) {
                        match = this.getCorrectMatch(matches, i);
                        if (match == null) continue;
                        refName_n = refName + UNDERSCORE + i;
                        vars.put(refName_n, match);
                    }
                }
                for (i = matchCount + 1; i <= prevCount; ++i) {
                    refName_n = refName + UNDERSCORE + i;
                    vars.remove(refName_n);
                }
            }
            catch (RuntimeException e) {
                log.warn("Error while generating result");
            }
        }
        catch (RuntimeException e) {
            log.warn("Error while generating result");
        }
    }

    private String getCorrectMatch(List<String> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(JMeterUtils.getRandomInt((int)matchSize));
        }
        return matches.get(entry - 1);
    }

    private List<String> extractMatchingStrings(JMeterVariables vars, String expression, String attribute, int matchNumber, SampleResult previousResult) {
        int found = 0;
        ArrayList<String> result = new ArrayList<String>();
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            this.getExtractorImpl().extract(expression, attribute, matchNumber, inputString, result, found, "-1");
        } else {
            List sampleList = this.getSampleList(previousResult);
            int i = 0;
            for (SampleResult sr : sampleList) {
                String inputString = sr.getResponseDataAsString();
                found = this.getExtractorImpl().extract(expression, attribute, matchNumber, inputString, result, found, i > 0 ? null : Integer.toString(i));
                ++i;
                if (matchNumber <= 0 || found != matchNumber) continue;
                break;
            }
        }
        return result;
    }

    private Extractor getExtractorImpl() {
        if (this.extractor == null) {
            boolean useDefaultExtractor = DEFAULT_EXTRACTOR.equals(this.getExtractor());
            if (useDefaultExtractor || EXTRACTOR_JSOUP.equals(this.getExtractor())) {
                this.extractor = new JSoupExtractor();
            } else if (EXTRACTOR_JODD.equals(this.getExtractor())) {
                this.extractor = new JSoupExtractor();
            } else {
                throw new IllegalArgumentException("Extractor implementation:" + this.getExtractor() + " is unknown");
            }
        }
        return this.extractor;
    }

    public void setExtractor(String attribute) {
        this.setProperty(EXTRACTOR_IMPL, attribute);
    }

    public String getExtractor() {
        return this.getPropertyAsString(EXTRACTOR_IMPL);
    }

    public void setAttribute(String attribute) {
        this.setProperty(ATTRIBUTE, attribute);
    }

    public String getAttribute() {
        return this.getPropertyAsString(ATTRIBUTE, DEFAULT_EXTRACTOR);
    }

    public void setExpression(String regex) {
        this.setProperty(EXPRESSION, regex);
    }

    public String getExpression() {
        return this.getPropertyAsString(EXPRESSION);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty((JMeterProperty)new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER);
    }

    public String getMatchNumberAsString() {
        return this.getPropertyAsString(MATCH_NUMBER);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }
}

