/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import jodd.lagarto.LagartoException;
import jodd.lagarto.Tag;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.TagWriterUtil;

public class TagWriter
implements TagVisitor {
    protected final boolean forceBuild;
    protected Appendable appendable;

    public TagWriter(Appendable appendable) {
        this.appendable = appendable;
        this.forceBuild = false;
    }

    public TagWriter(Appendable appendable, boolean forceBuild) {
        this.appendable = appendable;
        this.forceBuild = forceBuild;
    }

    public void setOutput(Appendable out) {
        this.appendable = out;
    }

    public Appendable getOutput() {
        return this.appendable;
    }

    public void start() {
    }

    public void end() {
    }

    public void tag(Tag tag) {
        try {
            tag.writeTo(this.appendable, this.forceBuild);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void xmp(Tag tag, CharSequence body) {
        try {
            tag.writeTo(this.appendable, this.forceBuild);
            if (body != null) {
                this.appendable.append(body);
            }
            this.appendable.append("</xmp>");
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void style(Tag tag, CharSequence body) {
        try {
            tag.writeTo(this.appendable, this.forceBuild);
            if (body != null) {
                this.appendable.append(body);
            }
            this.appendable.append("</style>");
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void script(Tag tag, CharSequence body) {
        try {
            tag.writeTo(this.appendable, this.forceBuild);
            if (body != null) {
                this.appendable.append(body);
            }
            this.appendable.append("</script>");
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void comment(CharSequence comment) {
        try {
            TagWriterUtil.writeComment(this.appendable, comment);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void text(CharSequence text) {
        try {
            this.appendable.append(text);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void cdata(CharSequence cdata) {
        try {
            TagWriterUtil.writeCData(this.appendable, cdata);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void xml(Tag tag) {
        try {
            tag.writeTo(this.appendable, this.forceBuild);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void doctype(String name, String publicId, String baseUri) {
        try {
            TagWriterUtil.writeDoctype(this.appendable, name, publicId, baseUri);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, CharSequence comment) {
        try {
            TagWriterUtil.writeConditionalComment(this.appendable, expression, isStartingTag, isHidden, comment);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void error(String message) {
    }
}

