/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.protocol.java.config.JavaConfig;
import org.apache.jmeter.protocol.java.sampler.JavaSampler;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class JavaConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JComboBox classnameCombo;
    private boolean displayName = true;
    private ArgumentsPanel argsPanel;

    public JavaConfigGui() {
        this(true);
    }

    public JavaConfigGui(boolean displayNameField) {
        this.displayName = displayNameField;
        this.init();
    }

    public String getLabelResource() {
        return "java_request_defaults";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        JPanel classnameRequestPanel = new JPanel(new BorderLayout(0, 5));
        classnameRequestPanel.add((Component)this.createClassnamePanel(), "North");
        classnameRequestPanel.add((Component)this.createParameterPanel(), "Center");
        this.add(classnameRequestPanel, "Center");
    }

    private JPanel createClassnamePanel() {
        List possibleClasses = new ArrayList();
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{JavaSamplerClient.class});
            possibleClasses.remove(JavaSampler.class.getName() + "$ErrorSamplerClient");
        }
        catch (Exception e) {
            log.debug("Exception getting interfaces.", (Throwable)e);
        }
        JLabel label = new JLabel(JMeterUtils.getResString((String)"protocol_java_classname"));
        this.classnameCombo = new JComboBox<Object>(possibleClasses.toArray());
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setEditable(false);
        label.setLabelFor(this.classnameCombo);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.classnameCombo);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.classnameCombo) {
            String className = ((String)this.classnameCombo.getSelectedItem()).trim();
            try {
                JavaSamplerClient client = (JavaSamplerClient)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                Arguments currArgs = new Arguments();
                this.argsPanel.modifyTestElement((TestElement)currArgs);
                Map currArgsMap = currArgs.getArgumentsAsMap();
                Arguments newArgs = new Arguments();
                Arguments testParams = null;
                try {
                    testParams = client.getDefaultParameters();
                }
                catch (AbstractMethodError e) {
                    log.warn("JavaSamplerClient doesn't implement getDefaultParameters.  Default parameters won't be shown.  Please update your client class: " + className);
                }
                if (testParams != null) {
                    PropertyIterator i = testParams.getArguments().iterator();
                    while (i.hasNext()) {
                        String newVal;
                        Argument arg = (Argument)i.next().getObjectValue();
                        String name = arg.getName();
                        String value = arg.getValue();
                        if (currArgsMap.containsKey(name) && (newVal = (String)currArgsMap.get(name)) != null && newVal.length() > 0) {
                            value = newVal;
                        }
                        newArgs.addArgument(name, value);
                    }
                }
                this.argsPanel.configure((TestElement)newArgs);
            }
            catch (Exception e) {
                log.error("Error getting argument list for " + className, (Throwable)e);
            }
        }
    }

    private JPanel createParameterPanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"paramtable"));
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments").getObjectValue()));
        this.classnameCombo.setSelectedItem(config.getPropertyAsString("classname"));
    }

    public TestElement createTestElement() {
        JavaConfig config = new JavaConfig();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        this.configureTestElement(config);
        ((JavaConfig)config).setArguments((Arguments)this.argsPanel.createTestElement());
        ((JavaConfig)config).setClassname(String.valueOf(this.classnameCombo.getSelectedItem()));
    }

    public void clearGui() {
        super.clearGui();
        this.displayName = true;
        this.argsPanel.clearGui();
        this.classnameCombo.setSelectedIndex(0);
    }
}

