/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.PoolSettable;
import org.apache.avalon.excalibur.datasource.ProxiedJdbcConnection;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class AbstractJdbcConnection
extends AbstractLogEnabled
implements PoolSettable,
Disposable,
ProxiedJdbcConnection {
    protected Connection m_connection;
    private Object m_proxy;
    protected Pool m_pool;
    protected PreparedStatement m_testStatement;
    protected SQLException m_testException;
    protected long m_lastUsed = System.currentTimeMillis();
    private static final Map m_methods = new HashMap();
    private final List m_allocatedStatements = new LinkedList();
    static /* synthetic */ Class class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection;

    public AbstractJdbcConnection(Connection connection, boolean oradb) {
        this(connection, oradb ? "select 1 from dual" : "select 1");
    }

    public AbstractJdbcConnection(Connection connection, String keepAlive) {
        this.m_connection = connection;
        this.initialize();
        if (null == keepAlive || "".equals(keepAlive.trim())) {
            this.m_testStatement = null;
            this.m_testException = null;
        } else {
            try {
                this.m_testStatement = this.m_connection.prepareStatement(keepAlive);
            }
            catch (SQLException se) {
                this.m_testStatement = null;
                this.m_testException = se;
            }
        }
    }

    public void initialize() {
    }

    public void enableLogging(Logger log) {
        super.enableLogging(log);
        if (this.m_testStatement == null && this.m_testException != null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not prepare test statement, connection recycled on basis of time.", (Throwable)this.m_testException);
            }
            this.m_testException = null;
        }
    }

    public void setPool(Pool pool) {
        this.m_pool = pool;
    }

    public void recycle() {
        this.m_testException = null;
        try {
            this.clearAllocatedStatements();
            this.m_connection.clearWarnings();
        }
        catch (SQLException se) {}
    }

    public void setProxiedConnection(Object proxy) {
        this.m_proxy = proxy;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public boolean isClosed() throws SQLException {
        if (this.m_connection.isClosed()) {
            return true;
        }
        long age = System.currentTimeMillis() - this.m_lastUsed;
        if (this.m_testStatement != null && age > 5000L) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Pinging database after " + age + "ms of inactivity.");
            }
            try {
                ResultSet rs = this.m_testStatement.executeQuery();
                rs.close();
            }
            catch (SQLException se) {
                this.getLogger().debug("Ping of connection failed.", (Throwable)se);
                this.dispose();
                return true;
            }
        }
        return false;
    }

    public void close() throws SQLException {
        try {
            this.clearAllocatedStatements();
            this.m_connection.clearWarnings();
            this.m_pool.put((Poolable)this.m_proxy);
        }
        catch (SQLException se) {
            this.getLogger().error("Connection could not be recycled", (Throwable)se);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllocatedStatements() throws SQLException {
        List list = this.m_allocatedStatements;
        synchronized (list) {
            try {
                Iterator iterator = this.m_allocatedStatements.iterator();
                while (iterator.hasNext()) {
                    Statement stmt = (Statement)iterator.next();
                    stmt.close();
                }
                Object var5_4 = null;
                this.m_allocatedStatements.clear();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.m_allocatedStatements.clear();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllocatedStatement(Statement stmt) {
        List list = this.m_allocatedStatements;
        synchronized (list) {
            this.m_allocatedStatements.add(stmt);
        }
    }

    public void dispose() {
        block2: {
            try {
                this.m_connection.close();
            }
            catch (SQLException se) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Could not close connection", (Throwable)se);
            }
        }
    }

    public boolean equals(Object obj) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof ProxiedJdbcConnection) {
            return this.m_connection.equals(((ProxiedJdbcConnection)handler).getConnection());
        }
        return false;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retVal = null;
        Method executeMethod = (Method)m_methods.get(method.getName());
        try {
            retVal = null == executeMethod ? method.invoke((Object)this.m_connection, args) : executeMethod.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method[] methods = (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection == null ? (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection = AbstractJdbcConnection.class$("org.apache.avalon.excalibur.datasource.AbstractJdbcConnection")) : class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection).getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            m_methods.put(methods[i].getName(), methods[i]);
            ++i;
        }
    }
}

