/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.regex.Pattern;

class FailureScanner {
    private static final String REQUEST_FAILURE_PATTERN = "s=\"false\"";
    private final boolean ignoreFailures;
    private int failureCount;

    public FailureScanner(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean hasTestFailed(File file) throws IOException {
        if (this.ignoreFailures) {
            return false;
        }
        this.failureCount = 0;
        Pattern errorPattern = Pattern.compile(REQUEST_FAILURE_PATTERN);
        Scanner resultFileScanner = new Scanner(file);
        while (resultFileScanner.findWithinHorizon(errorPattern, 0) != null) {
            ++this.failureCount;
        }
        resultFileScanner.close();
        return this.failureCount > 0;
    }

    public int getFailureCount() {
        return this.failureCount;
    }
}

