/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.SamplingStatCalculator;

public class CachingStatCalculator
extends SamplingStatCalculator {
    private final List<Sample> storedValues = Collections.synchronizedList(new ArrayList());

    public CachingStatCalculator(String string) {
        super(string);
    }

    public List<Sample> getSamples() {
        return this.storedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int index) {
        List<Sample> list = this.storedValues;
        synchronized (list) {
            if (index < this.storedValues.size()) {
                return this.storedValues.get(index);
            }
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.storedValues.clear();
    }

    @Override
    public Sample addSample(SampleResult res) {
        Sample sample = super.addSample(res);
        this.storedValues.add(sample);
        return sample;
    }
}

