/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextAreaEditor
extends PropertyEditorSupport
implements FocusListener {
    private JTextArea textUI;
    private JScrollPane scroller;

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }

    private final void init() {
        this.textUI = new JTextArea();
        this.textUI.addFocusListener(this);
        this.textUI.setWrapStyleWord(true);
        this.textUI.setLineWrap(true);
        this.scroller = new JScrollPane(this.textUI, 20, 31);
    }

    public TextAreaEditor() {
        this.init();
    }

    public TextAreaEditor(Object source) {
        super(source);
        this.init();
        this.setValue(source);
    }

    @Override
    public String getAsText() {
        return this.textUI.getText();
    }

    @Override
    public Component getCustomEditor() {
        return this.scroller;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.textUI.setText(text);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.textUI.setText(value.toString());
        } else {
            this.textUI.setText("");
        }
    }

    @Override
    public Object getValue() {
        return this.textUI.getText();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

