/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GenericController
extends AbstractTestElement
implements Controller,
Serializable,
TestCompilerHelper {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private transient LinkedList<LoopIterationListener> iterationListeners = new LinkedList();
    private final transient ConcurrentMap<TestElement, Object> children = TestCompiler.IS_USE_STATIC_SET ? null : new ConcurrentHashMap();
    private static final Object DUMMY = new Object();
    protected transient List<TestElement> subControllersAndSamplers = new ArrayList<TestElement>();
    protected transient int current;
    private transient int iterCount;
    private transient boolean done;
    private transient boolean first;

    @Override
    public void initialize() {
        this.resetCurrent();
        this.resetIterCount();
        this.done = false;
        this.first = true;
        for (int i = 0; i < this.subControllersAndSamplers.size(); ++i) {
            TestElement elem = this.subControllersAndSamplers.get(i);
            if (!(elem instanceof Controller)) continue;
            ((Controller)elem).initialize();
        }
    }

    protected void reInitialize() {
        this.resetCurrent();
        this.incrementIterCount();
        this.setFirst(true);
        this.recoverRunningVersion();
    }

    @Override
    public Sampler next() {
        this.fireIterEvents();
        if (log.isDebugEnabled()) {
            log.debug("Calling next on: " + this.getClass().getName());
        }
        if (this.isDone()) {
            return null;
        }
        Sampler returnValue = null;
        try {
            TestElement currentElement = this.getCurrentElement();
            this.setCurrentElement(currentElement);
            returnValue = currentElement == null ? this.nextIsNull() : (currentElement instanceof Sampler ? this.nextIsASampler((Sampler)currentElement) : this.nextIsAController((Controller)currentElement));
        }
        catch (NextIsNullException nextIsNullException) {
            // empty catch block
        }
        return returnValue;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean done) {
        this.done = done;
    }

    protected boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean b) {
        this.first = b;
    }

    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler sampler = null;
        try {
            sampler = controller.next();
        }
        catch (StackOverflowError soe) {
            log.warn("StackOverflowError detected");
            throw new NextIsNullException("StackOverflowError detected", soe);
        }
        if (sampler == null) {
            this.currentReturnedNull(controller);
            sampler = this.next();
        }
        return sampler;
    }

    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.incrementCurrent();
        return element;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        return null;
    }

    @Override
    public void triggerEndOfLoop() {
        this.reInitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reInitializeSubController() {
        boolean wasFlagSet = this.getThreadContext().setIsReinitializingSubControllers();
        try {
            TestElement currentElement = this.getCurrentElement();
            if (currentElement != null) {
                if (currentElement instanceof Sampler) {
                    this.nextIsASampler((Sampler)currentElement);
                } else if (this.nextIsAController((Controller)currentElement) != null) {
                    this.reInitializeSubController();
                }
            }
        }
        catch (NextIsNullException nextIsNullException) {
        }
        finally {
            if (wasFlagSet) {
                this.getThreadContext().unsetIsReinitializingSubControllers();
            }
        }
    }

    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else {
            this.incrementCurrent();
        }
    }

    protected List<TestElement> getSubControllers() {
        return this.subControllersAndSamplers;
    }

    private void addElement(TestElement child) {
        this.subControllersAndSamplers.add(child);
    }

    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
    }

    protected TestElement getCurrentElement() throws NextIsNullException {
        if (this.current < this.subControllersAndSamplers.size()) {
            return this.subControllersAndSamplers.get(this.current);
        }
        if (this.subControllersAndSamplers.size() == 0) {
            this.setDone(true);
            throw new NextIsNullException();
        }
        return null;
    }

    protected void removeCurrentElement() {
        this.subControllersAndSamplers.remove(this.current);
    }

    protected void incrementCurrent() {
        ++this.current;
    }

    protected void resetCurrent() {
        this.current = 0;
    }

    @Override
    public void addTestElement(TestElement child) {
        if (child instanceof Controller || child instanceof Sampler) {
            this.addElement(child);
        }
    }

    @Override
    public final boolean addTestElementOnce(TestElement child) {
        if (this.children.putIfAbsent(child, DUMMY) == null) {
            this.addTestElement(child);
            return true;
        }
        return false;
    }

    @Override
    public void addIterationListener(LoopIterationListener lis) {
        this.iterationListeners.addFirst(lis);
    }

    @Override
    public void removeIterationListener(LoopIterationListener iterationListener) {
        Iterator iterator = this.iterationListeners.iterator();
        while (iterator.hasNext()) {
            LoopIterationListener listener = (LoopIterationListener)iterator.next();
            if (listener != iterationListener) continue;
            iterator.remove();
            break;
        }
    }

    protected void fireIterEvents() {
        if (this.isFirst()) {
            this.fireIterationStart();
            this.first = false;
        }
    }

    protected void fireIterationStart() {
        LoopIterationEvent event = new LoopIterationEvent(this, this.getIterCount());
        for (LoopIterationListener item : this.iterationListeners) {
            item.iterationStart(event);
        }
    }

    protected int getIterCount() {
        return this.iterCount;
    }

    protected void incrementIterCount() {
        ++this.iterCount;
    }

    protected void resetIterCount() {
        this.iterCount = 0;
    }
}

