/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jbehave.scenario.reporters.FreemarkerReportRenderer;

public class ReportRendererTask
extends Task {
    private String outputDirectory = "target/jbehave-reports";
    private List<String> formats = Arrays.asList(new Object[0]);
    private boolean skip = false;
    private boolean ignoreFailure = false;
    private Properties templateProperties = new Properties();

    public void execute() throws BuildException {
        if (this.skip) {
            this.log("Skipped rendering reports", 2);
            return;
        }
        FreemarkerReportRenderer renderer = new FreemarkerReportRenderer(this.templateProperties);
        try {
            this.log("Rendering reports in '" + this.outputDirectory + "' using formats '" + this.formats + "'" + " and template properties '" + this.templateProperties + "'", 2);
            renderer.render(new File(this.outputDirectory), this.formats);
        }
        catch (Throwable e) {
            String message = "Failed to render reports in '" + this.outputDirectory + "' using formats '" + this.formats + "'" + " and template properties '" + this.templateProperties + "'";
            this.log(message, 1);
            throw new BuildException(message, e);
        }
        int scenarios = renderer.countScenarios();
        int failed = renderer.countFailedScenarios();
        String message = "Rendered reports with " + scenarios + " scenarios (of which " + failed + " failed)";
        this.log(message, 2);
        if (!this.ignoreFailure && failed > 0) {
            throw new BuildException(message);
        }
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFormats(String formats) {
        this.formats = Arrays.asList(formats.split(","));
    }

    public void setTemplateProperties(String properties) {
        try {
            this.templateProperties.load(new ByteArrayInputStream(properties.getBytes()));
        }
        catch (IOException e) {
            String message = "Failed to load template properties: " + properties;
            this.log(message, 1);
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }
}

