/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.util.CompoundRoot;
import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ognl.ClassResolver;
import ognl.Evaluation;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompoundRootAccessor
implements PropertyAccessor,
MethodAccessor,
ClassResolver {
    private static final Log log = LogFactory.getLog(CompoundRootAccessor.class);
    private static Map invalidMethods = new HashMap();

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        for (Object o : root) {
            if (o == null) continue;
            try {
                if (!OgnlRuntime.hasSetProperty((OgnlContext)ognlContext, o, (Object)name)) continue;
                OgnlRuntime.setProperty((OgnlContext)ognlContext, o, (Object)name, (Object)value);
                return;
            }
            catch (OgnlException e) {
                if (e.getReason() == null) continue;
                String msg = "Caught an Ognl exception while setting property " + name;
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg);
            }
            catch (IntrospectionException e) {
            }
        }
        Boolean reportError = (Boolean)context.get("com.opensymphony.xwork.util.OgnlValueStack.ReportErrorsOnNoProp");
        String msg = "No object in the CompoundRoot has a property named '" + name + "'.";
        if (reportError != null && reportError.booleanValue()) {
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        log.debug((Object)msg);
    }

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        if (name instanceof Integer) {
            Integer index = (Integer)name;
            return root.cutStack(index);
        }
        if (name instanceof String) {
            if ("top".equals(name)) {
                if (root.size() > 0) {
                    return root.get(0);
                }
                return null;
            }
            for (Object o : root) {
                if (o == null) continue;
                try {
                    if (!OgnlRuntime.hasGetProperty((OgnlContext)ognlContext, o, (Object)name) && (!(o instanceof Map) || !((Map)o).containsKey(name))) continue;
                    Object value = OgnlRuntime.getProperty((OgnlContext)ognlContext, o, (Object)name);
                    Evaluation currentEvaluation = ognlContext.getCurrentEvaluation();
                    SimpleNode node = currentEvaluation.getNode();
                    currentEvaluation.setSource(o);
                    ognlContext.pushEvaluation(new Evaluation(node, o));
                    return value;
                }
                catch (OgnlException e) {
                    if (e.getReason() == null) continue;
                    String msg = "Caught an Ognl exception while getting property " + name;
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg);
                }
                catch (IntrospectionException e) {
                }
            }
            return null;
        }
        return null;
    }

    public Object callMethod(Map context, Object target, String name, Object[] objects) throws MethodFailedException {
        CompoundRoot root = (CompoundRoot)target;
        for (Object o : root) {
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            Class[] argTypes = this.getArgTypes(objects);
            MethodCall mc = null;
            if (argTypes != null) {
                mc = new MethodCall(clazz, name, argTypes);
            }
            if (argTypes != null && invalidMethods.containsKey(mc)) continue;
            try {
                Object value = OgnlRuntime.callMethod((OgnlContext)((OgnlContext)context), o, (String)name, (String)name, (Object[])objects);
                if (value == null) continue;
                return value;
            }
            catch (OgnlException e) {
                Throwable reason = e.getReason();
                if (mc != null && reason != null && reason.getClass() == NoSuchMethodException.class) {
                    invalidMethods.put(mc, Boolean.TRUE);
                    continue;
                }
                if (reason == null) continue;
                throw new MethodFailedException(o, name, e.getReason());
            }
        }
        return null;
    }

    public Object callStaticMethod(Map transientVars, Class aClass, String s, Object[] objects) throws MethodFailedException {
        return null;
    }

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        Object root = Ognl.getRoot((Map)context);
        try {
            if (root instanceof CompoundRoot && className.startsWith("vs")) {
                CompoundRoot compoundRoot = (CompoundRoot)root;
                if (className.equals("vs")) {
                    return compoundRoot.peek().getClass();
                }
                int index = Integer.parseInt(className.substring(2));
                return compoundRoot.get(index - 1).getClass();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    private Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            classes[i] = arg != null ? arg.getClass() : Object.class;
        }
        return classes;
    }

    static class MethodCall {
        Class clazz;
        String name;
        Class[] args;
        int hash;

        public MethodCall(Class clazz, String name, Class[] args) {
            this.clazz = clazz;
            this.name = name;
            this.args = args;
            this.hash = clazz.hashCode() + name.hashCode();
            for (int i = 0; i < args.length; ++i) {
                Class arg = args[i];
                this.hash += arg.hashCode();
            }
        }

        public boolean equals(Object obj) {
            MethodCall mc = (MethodCall)obj;
            return mc.clazz.equals(this.clazz) && mc.name.equals(this.name) && Arrays.equals(mc.args, this.args);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

