/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor.component;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.Disposable;
import com.opensymphony.xwork.interceptor.component.Initializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultComponentManager
implements ComponentManager,
Serializable {
    private static final Log log = LogFactory.getLog(DefaultComponentManager.class);
    Map enablers = new HashMap();
    Map enablers2 = new HashMap();
    private DefaultComponentManager fallback;
    private List loadOrder = new ArrayList();
    private Map resourceInstances = new HashMap();
    private Set alreadyLoaded = new HashSet();

    public Object getComponent(Class enablerType) {
        DefaultComponentManager dcm = this;
        Class resource = null;
        while (dcm != null && (resource = (Class)dcm.enablers.get(enablerType)) == null) {
            dcm = dcm.fallback;
        }
        if (resource == null) {
            return null;
        }
        try {
            ResourceEnablerPair pair = this.setupAndOptionallyCreateResource(dcm, resource);
            return pair.resource;
        }
        catch (Exception e) {
            String message = "Could not load resource with enabler " + enablerType;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public void setFallback(ComponentManager fallback) {
        if (!(fallback instanceof DefaultComponentManager)) {
            throw new RuntimeException("Fallback must be an instance of DefaultConfigurationManager");
        }
        this.fallback = (DefaultComponentManager)fallback;
    }

    public void addEnabler(Class component, Class enablerType) {
        this.enablers.put(enablerType, component);
        this.enablers2.put(component, enablerType);
    }

    public void dispose() {
        Collections.reverse(this.loadOrder);
        for (Object resource : this.loadOrder) {
            if (!(resource instanceof Disposable)) continue;
            Disposable disposable = (Disposable)resource;
            disposable.dispose();
        }
    }

    public void initializeObject(Object obj) {
        this.loadResource(obj, obj.getClass(), this);
    }

    private Map getResourceDependencies(Class resourceClass) {
        ArrayList interfaces = new ArrayList();
        this.addAllInterfaces(resourceClass, interfaces);
        HashMap<Class, DefaultComponentManager> dependencies = new HashMap<Class, DefaultComponentManager>();
        block0: for (Class anInterface : interfaces) {
            DefaultComponentManager dcm = this;
            while (dcm != null) {
                Class possibleResource = (Class)dcm.enablers.get(anInterface);
                if (possibleResource != null) {
                    dependencies.put(possibleResource, dcm);
                    continue block0;
                }
                dcm = dcm.fallback;
            }
        }
        return dependencies;
    }

    private void addAllInterfaces(Class clazz, List allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        this.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    private Class loadResource(Object resource, Class clazz, DefaultComponentManager dcm) {
        boolean resourceNotLoaded;
        boolean bl = resourceNotLoaded = !dcm.loadOrder.contains(resource);
        if (resourceNotLoaded) {
            Map resources = this.getResourceDependencies(clazz);
            for (Map.Entry mapEntry : resources.entrySet()) {
                Class depResource = (Class)mapEntry.getKey();
                DefaultComponentManager newDcm = (DefaultComponentManager)mapEntry.getValue();
                try {
                    ResourceEnablerPair pair = this.setupAndOptionallyCreateResource(newDcm, depResource);
                    this.setupResource(resource, pair.enabler, pair.resource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Error loading or setting up resource: " + resources.getClass().getName()), (Throwable)e);
                }
            }
            dcm.alreadyLoaded.add(clazz);
            if (resource instanceof Initializable) {
                Initializable initializable = (Initializable)resource;
                initializable.init();
            }
            dcm.resourceInstances.put(clazz, resource);
            dcm.loadOrder.add(resource);
        }
        Class enabler = (Class)dcm.enablers2.get(clazz);
        return enabler;
    }

    private ResourceEnablerPair setupAndOptionallyCreateResource(DefaultComponentManager newDcm, Class depResource) throws Exception {
        Class enabler;
        ResourceEnablerPair pair = new ResourceEnablerPair();
        Object newResource = newDcm.resourceInstances.get(depResource);
        if (newResource == null) {
            newResource = ObjectFactory.getObjectFactory().buildBean(depResource);
        }
        pair.resource = newResource;
        pair.enabler = enabler = this.loadResource(newResource, depResource, newDcm);
        return pair;
    }

    private void setupResource(Object resource, Class enabler, Object newResource) {
        block3: {
            if (enabler == null) {
                return;
            }
            try {
                enabler.getMethods()[0].invoke(resource, newResource);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Error invoking method for resource: " + resource.getClass().getName()), (Throwable)e);
            }
        }
    }

    class ResourceEnablerPair {
        Class enabler;
        Object resource;

        ResourceEnablerPair() {
        }
    }
}

