/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor.component;

import com.opensymphony.xwork.interceptor.component.ComponentManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ComponentConfiguration
implements Serializable {
    private static final Log log = LogFactory.getLog(ComponentConfiguration.class);
    private Map componentsByScope = new HashMap();

    public void addComponentDefinition(String className, String scope, String enablerClass) {
        this.getComponents(scope).add(new ComponentDefinition(className, enablerClass));
    }

    public void configure(ComponentManager componentManager, String scope) {
        for (ComponentDefinition componentDefinition : this.getComponents(scope)) {
            Class resource = this.loadClass(componentDefinition.className);
            Class enabler = this.loadClass(componentDefinition.enablerClass);
            componentManager.addEnabler(resource, enabler);
        }
    }

    public boolean hasComponents(String scope) {
        return this.componentsByScope.containsKey(scope);
    }

    public void loadFromXml(InputStream is) throws IOException, SAXException {
        DocumentBuilder db = null;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"ParserConfigurationException occured", (Throwable)e);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            log.error((Object)"FactoryConfigurationError occured", (Throwable)factoryConfigurationError);
        }
        Element componentsElement = db.parse(is).getDocumentElement();
        NodeList components = componentsElement.getChildNodes();
        for (int i = 0; i < components.getLength(); ++i) {
            Node componentNode = components.item(i);
            if (!(componentNode instanceof Element)) continue;
            Element componentElement = (Element)componentNode;
            NodeList componentElementChildren = componentElement.getChildNodes();
            String className = null;
            String scope = null;
            String enabler = null;
            for (int j = 0; j < componentElementChildren.getLength(); ++j) {
                Node elementChildNode = componentElementChildren.item(j);
                if (!(elementChildNode instanceof Element)) continue;
                Element childElement = (Element)elementChildNode;
                if ("class".equals(childElement.getNodeName())) {
                    className = childElement.getChildNodes().item(0).getNodeValue();
                    continue;
                }
                if ("scope".equals(childElement.getNodeName())) {
                    scope = childElement.getChildNodes().item(0).getNodeValue();
                    continue;
                }
                if (!"enabler".equals(childElement.getNodeName())) continue;
                enabler = childElement.getChildNodes().item(0).getNodeValue();
            }
            if (className == null || scope == null || enabler == null) continue;
            this.addComponentDefinition(className.trim(), scope.trim(), enabler.trim());
        }
    }

    private List getComponents(String scope) {
        if (!this.componentsByScope.containsKey(scope)) {
            this.componentsByScope.put(scope, new ArrayList(10));
        }
        return (List)this.componentsByScope.get(scope);
    }

    private Class loadClass(String enablerClass) {
        try {
            return Class.forName(enablerClass);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)("Cannot load class : " + enablerClass), (Throwable)e);
            throw new RuntimeException("Cannot load class : " + enablerClass);
        }
    }

    private class ComponentDefinition
    implements Serializable {
        private String className;
        private String enablerClass;

        public ComponentDefinition(String className, String enablerClass) {
            this.enablerClass = enablerClass;
            this.className = className;
        }
    }
}

