/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class IssuingDelegatedAssertionPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, DelegationContext> delegationContextLookupStrategy = new ChildContextLookup(DelegationContext.class);

    public void setDelegationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DelegationContext> strategy) {
        this.delegationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DelegationContext lookup strategy may not be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return false;
        }
        DelegationContext delegationContext = (DelegationContext)((Object)this.delegationContextLookupStrategy.apply((Object)input));
        if (delegationContext == null) {
            return false;
        }
        return delegationContext.isIssuingDelegatedAssertion();
    }
}

