/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;

public class LegacyEncryptionRequirementPredicate
extends NoConfidentialityMessageChannelPredicate {
    private final EncryptionRequirementSetting settingToApply;

    public LegacyEncryptionRequirementPredicate(@Nonnull @NotEmpty String setting) {
        Constraint.isNotNull((Object)setting, (String)"Encryption requirement setting cannot be null");
        if ("always".equals(setting)) {
            this.settingToApply = EncryptionRequirementSetting.ALWAYS;
        } else if ("conditional".equals(setting)) {
            this.settingToApply = EncryptionRequirementSetting.CONDITIONAL;
        } else if ("never".equals(setting)) {
            this.settingToApply = EncryptionRequirementSetting.NEVER;
        } else {
            throw new IllegalArgumentException("Encryption requirement setting not one of the supported values");
        }
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        switch (this.settingToApply) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case CONDITIONAL: {
                return super.apply(input);
            }
        }
        throw new IllegalArgumentException("Encryption requirement setting not one of the supported values");
    }

    private static enum EncryptionRequirementSetting {
        ALWAYS,
        CONDITIONAL,
        NEVER;

    }
}

