/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnContextDecl;
import org.w3c.dom.Node;

public final class AuthnContextDeclPrincipal
implements CloneablePrincipal {
    @Nonnull
    private AuthnContextDecl authnContextDecl;
    @Nonnull
    @NotEmpty
    private String name;

    public AuthnContextDeclPrincipal(@Nonnull @ParameterName(name="decl") AuthnContextDecl decl) throws MarshallingException {
        this.authnContextDecl = (AuthnContextDecl)Constraint.isNotNull((Object)decl, (String)"AuthnContextDeclRef cannot be null");
        this.name = SerializeSupport.nodeToString((Node)((Marshaller)Constraint.isNotNull((Object)XMLObjectSupport.getMarshaller((XMLObject)decl), (String)"No marshaller for AuthnContextDecl")).marshall((XMLObject)decl));
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.name;
    }

    @Nonnull
    public AuthnContextDecl getAuthnContextDecl() {
        return this.authnContextDecl;
    }

    public int hashCode() {
        return this.authnContextDecl.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AuthnContextDeclPrincipal) {
            return this.name.equals(((AuthnContextDeclPrincipal)other).getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnContextDecl", (Object)this.name).toString();
    }

    public AuthnContextDeclPrincipal clone() throws CloneNotSupportedException {
        AuthnContextDeclPrincipal copy = (AuthnContextDeclPrincipal)super.clone();
        try {
            copy.authnContextDecl = (AuthnContextDecl)XMLObjectSupport.cloneXMLObject((XMLObject)this.authnContextDecl, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.RootDOMInNewDocument);
            copy.name = SerializeSupport.nodeToString((Node)((Marshaller)Constraint.isNotNull((Object)XMLObjectSupport.getMarshaller((XMLObject)copy.authnContextDecl), (String)"No marshaller for AuthnContextDecl")).marshall((XMLObject)copy.authnContextDecl));
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new XMLRuntimeException((Exception)e);
        }
        return copy;
    }
}

