/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeValueMapper;
import net.shibboleth.idp.saml.attribute.mapping.AttributeMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributeMapper<InType extends Attribute, OutType extends IdPAttribute>
extends AbstractIdentifiableInitializableComponent
implements AttributeMapper<InType, OutType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeMapper.class);
    @Nonnull
    @NonnullElements
    private List<String> attributeIds = Collections.emptyList();
    @Nullable
    private String attributeFormat;
    @NonnullAfterInit
    private String theSAMLName;
    @Nullable
    private String logPrefix;
    @NonnullAfterInit
    private AbstractSAMLAttributeValueMapper valueMapper;

    public void setAttributeIds(@Nullable @NullableElements List<String> theIds) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (null == theIds) {
            return;
        }
        this.attributeIds = ImmutableList.copyOf((Collection)StringSupport.normalizeStringCollection(theIds));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<String> getAttributeIds() {
        return this.attributeIds;
    }

    public void setSAMLName(@Nullable String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.theSAMLName = StringSupport.trimOrNull((String)name);
    }

    @NonnullAfterInit
    public String getSAMLName() {
        return this.theSAMLName;
    }

    public void setValueMapper(@Nullable AbstractSAMLAttributeValueMapper mapper) {
        this.valueMapper = mapper;
    }

    @NonnullAfterInit
    public AbstractSAMLAttributeValueMapper getValueMapper() {
        return this.valueMapper;
    }

    public void setAttributeFormat(@Nullable String format) {
        this.attributeFormat = StringSupport.trimOrNull((String)format);
    }

    @Nullable
    public String getAttributeFormat() {
        return this.attributeFormat;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.theSAMLName) {
            throw new ComponentInitializationException(this.getLogPrefix() + " SAML name not present");
        }
        if (null == this.valueMapper) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No value mapper present");
        }
        if (this.attributeIds.isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " At least one attribute Id should be provided");
        }
        this.logPrefix = null;
        this.valueMapper.setLogPrefix(this.getLogPrefix());
    }

    protected boolean matches(@Nonnull @NotEmpty String otherSAMLName, @Nullable String otherSAMLFormat) {
        if (!otherSAMLName.equals(this.theSAMLName)) {
            this.log.debug("{} SAML attribute name {} does not match {}", new Object[]{this.getLogPrefix(), otherSAMLName, this.getId()});
            return false;
        }
        String format = otherSAMLFormat;
        if (format != null && "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(format)) {
            format = null;
        }
        if (this.getAttributeFormat() != null && format != null && !this.getAttributeFormat().equals(format) && !"urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(this.getAttributeFormat())) {
            this.log.debug("{} SAML name format {} does not match {}", new Object[]{this.getLogPrefix(), format, this.getAttributeFormat()});
            return false;
        }
        return true;
    }

    protected boolean attributeMatches(@Nonnull InType attribute) {
        return this.matches(attribute.getName(), attribute.getNameFormat());
    }

    @Override
    @Nonnull
    @NonnullElements
    public Map<String, OutType> mapAttribute(@Nonnull InType prototype) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!this.attributeMatches(prototype)) {
            return Collections.emptyMap();
        }
        List inputValues = prototype.getAttributeValues();
        List<IdPAttributeValue<?>> outputValues = this.getValueMapper().decodeValues(inputValues);
        if (!inputValues.isEmpty() && outputValues.isEmpty()) {
            this.log.warn("{} Attribute '{}' value conversion yielded no suitable values", (Object)this.getLogPrefix(), (Object)prototype.getName());
            return Collections.emptyMap();
        }
        HashMap<String, OutType> output = new HashMap<String, OutType>(inputValues.size());
        this.log.debug("{} attribute id {} and aliases {} will be created", new Object[]{this.getLogPrefix(), this.getId(), this.getAttributeIds()});
        OutType out = this.newAttribute(prototype, this.getId());
        out.setValues(outputValues);
        for (String id : this.attributeIds) {
            out = this.newAttribute(prototype, this.getId());
            out.setValues(outputValues);
            output.put(id, out);
        }
        return output;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder();
            if (null != this.getValueMapper()) {
                builder.append(this.getValueMapper().getAttributeTypeName()).append(" ");
            }
            builder.append("Attribute Mapper '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractSAMLAttributeMapper) {
            AbstractSAMLAttributeMapper other = (AbstractSAMLAttributeMapper)obj;
            return this.matches(other.getSAMLName(), other.getAttributeFormat()) && Objects.equals(this.getAttributeIds(), other.getAttributeIds());
        }
        return false;
    }

    public int hashCode() {
        String myFormat = this.getAttributeFormat();
        if (null == myFormat) {
            myFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        }
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{myFormat, this.theSAMLName, this.attributeIds});
    }

    @Nonnull
    protected abstract OutType newAttribute(@Nonnull InType var1, @Nonnull @NotEmpty String var2);
}

