/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAMLAttributeEncoder;
import net.shibboleth.idp.saml.attribute.encoding.SAML2AttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;

public abstract class AbstractSAML2AttributeEncoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeEncoder<Attribute, EncodedType>
implements SAML2AttributeEncoder<EncodedType> {
    @Nonnull
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Attribute.TYPE_NAME);
    @Nullable
    private String friendlyName;
    @Nullable
    private String format;

    public AbstractSAML2AttributeEncoder() {
        if (this.attributeBuilder == null) {
            throw new ConstraintViolationException("SAML 2 Attribute builder is unavailable");
        }
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
    }

    @Nonnull
    public final String getProtocol() {
        return "urn:oasis:names:tc:SAML:2.0:protocol";
    }

    @Nullable
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(@Nullable String attributeFriendlyName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.friendlyName = StringSupport.trimOrNull((String)attributeFriendlyName);
    }

    @Override
    @Nullable
    public String getNameFormat() {
        return this.format;
    }

    @Nonnull
    @NotEmpty
    public String getEffectiveNameFormat() {
        return this.format != null ? this.format : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
    }

    public void setNameFormat(@Nullable String nameFormat) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.format = StringSupport.trimOrNull((String)nameFormat);
    }

    @Override
    @Nonnull
    protected Attribute buildAttribute(@Nonnull IdPAttribute idpAttribute, @Nonnull @NonnullElements List<XMLObject> attributeValues) throws AttributeEncodingException {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(this.getName());
        samlAttribute.setFriendlyName(this.getFriendlyName());
        samlAttribute.setNameFormat(this.getNameFormat());
        samlAttribute.getAttributeValues().addAll(attributeValues);
        return samlAttribute;
    }

    @Nonnull
    protected String getMapperId() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null != this.getFriendlyName()) {
            return "MapperFor" + this.getFriendlyName();
        }
        return "MapperForAttribute" + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractSAML2AttributeEncoder)) {
            return false;
        }
        AbstractSAML2AttributeEncoder other = (AbstractSAML2AttributeEncoder)obj;
        return Objects.equals(this.getEffectiveNameFormat(), other.getEffectiveNameFormat());
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getEffectiveNameFormat()});
    }
}

