/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal.util;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class Logger {
    public static final String TAG = "FirebaseAppCheck";
    static final Logger DEFAULT_LOGGER = new Logger("FirebaseAppCheck");
    private final String tag;
    private int logLevel;

    public Logger(@NonNull String tag) {
        this.tag = tag;
        this.logLevel = 4;
    }

    @NonNull
    public static Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    private boolean canLog(int level) {
        return this.logLevel <= level || Log.isLoggable((String)this.tag, (int)level);
    }

    public void d(@NonNull String text, @Nullable Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void v(@NonNull String text, @Nullable Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void i(@NonNull String text, @Nullable Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void w(@NonNull String text, @Nullable Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void e(@NonNull String text, @Nullable Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)this.tag, (String)text, (Throwable)throwable);
        }
    }

    public void d(@NonNull String text) {
        this.d(text, null);
    }

    public void v(@NonNull String text) {
        this.v(text, null);
    }

    public void i(@NonNull String text) {
        this.i(text, null);
    }

    public void w(@NonNull String text) {
        this.w(text, null);
    }

    public void e(@NonNull String text) {
        this.e(text, null);
    }

    public void log(int priority, @NonNull String msg) {
        this.log(priority, msg, false);
    }

    public void log(int priority, @NonNull String msg, boolean forceLog) {
        if (forceLog || this.canLog(priority)) {
            Log.println((int)priority, (String)this.tag, (String)msg);
        }
    }
}

