/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.barcode.internal;

import android.content.Context;
import android.media.Image;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_barcode.zzcv;
import com.google.android.gms.internal.mlkit_vision_barcode.zzpj;
import com.google.android.gms.internal.mlkit_vision_barcode.zztx;
import com.google.android.gms.internal.mlkit_vision_barcode.zzvj;
import com.google.android.gms.internal.mlkit_vision_barcode.zzvl;
import com.google.android.gms.internal.mlkit_vision_barcode.zzvt;
import com.google.android.gms.internal.mlkit_vision_barcode.zzvv;
import com.google.android.gms.internal.mlkit_vision_barcode.zzwc;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.barcode.common.internal.BarcodeSource;
import com.google.mlkit.vision.barcode.internal.zzb;
import com.google.mlkit.vision.barcode.internal.zzl;
import com.google.mlkit.vision.barcode.internal.zzm;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import java.util.ArrayList;
import java.util.List;

final class zzn
implements zzl {
    private static final zzcv zza = zzcv.zzh("com.google.android.gms.vision.barcode", "com.google.android.gms.tflite_dynamite");
    private boolean zzb;
    private boolean zzc;
    private boolean zzd;
    private final Context zze;
    private final BarcodeScannerOptions zzf;
    private final zztx zzg;
    @Nullable
    private zzvt zzh;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final List zza(InputImage inputImage) throws MlKitException {
        if (this.zzh == null) {
            this.zzc();
        }
        ArrayList<Barcode> arrayList = (zzvt)Preconditions.checkNotNull((Object)this.zzh);
        if (!this.zzb) {
            try {
                ((zzvt)((Object)arrayList)).zze();
                this.zzb = true;
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to init barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        int n = inputImage.getWidth();
        if (inputImage.getFormat() == 35) {
            n = ((Image.Plane[])Preconditions.checkNotNull((Object)inputImage.getPlanes()))[0].getRowStride();
        }
        AbstractSafeParcelable abstractSafeParcelable = new zzwc(inputImage.getFormat(), n, inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        Object object = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object = ((zzvt)((Object)arrayList)).zzd((IObjectWrapper)object, (zzwc)abstractSafeParcelable);
            arrayList = new ArrayList<Barcode>();
            object = object.iterator();
        }
        catch (RemoteException remoteException) {
            throw new MlKitException("Failed to run barcode scanner.", 13, (Throwable)remoteException);
        }
        while (object.hasNext()) {
            abstractSafeParcelable = (zzvj)((Object)object.next());
            arrayList.add(new Barcode((BarcodeSource)new zzm((zzvj)abstractSafeParcelable), inputImage.getCoordinatesMatrix()));
        }
        return arrayList;
    }

    zzn(Context context, BarcodeScannerOptions barcodeScannerOptions, zztx zztx2) {
        this.zze = context;
        this.zzf = barcodeScannerOptions;
        this.zzg = zztx2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzb() {
        zzvt zzvt2 = this.zzh;
        if (zzvt2 == null) {
            return;
        }
        try {
            zzvt2.zzf();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"DecoupledBarcodeScanner", (String)"Failed to release barcode scanner.", (Throwable)remoteException);
        }
        this.zzh = null;
        this.zzb = false;
    }

    static boolean zzd(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.mlkit.dynamite.barcode") > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final boolean zzc() throws MlKitException {
        if (this.zzh != null) {
            return this.zzc;
        }
        if (zzn.zzd(this.zze)) {
            this.zzc = true;
            try {
                this.zzh = this.zze(DynamiteModule.PREFER_LOCAL, "com.google.mlkit.dynamite.barcode", "com.google.mlkit.vision.barcode.bundled.internal.ThickBarcodeScannerCreator");
            }
            catch (DynamiteModule.LoadingException loadingException) {
                throw new MlKitException("Failed to load the bundled barcode module.", 13, (Throwable)loadingException);
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to create thick barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        this.zzc = false;
        if (!OptionalModuleUtils.areAllRequiredModulesAvailable((Context)this.zze, (List)zza)) {
            if (!this.zzd) {
                OptionalModuleUtils.requestDownload((Context)this.zze, (List)zzcv.zzh("barcode", "tflite_dynamite"));
                this.zzd = true;
            }
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzpj.zzB);
            throw new MlKitException("Waiting for the barcode module to be downloaded. Please wait.", 14);
        }
        try {
            this.zzh = this.zze(DynamiteModule.PREFER_REMOTE, "com.google.android.gms.vision.barcode", "com.google.android.gms.vision.barcode.mlkit.BarcodeScannerCreator");
        }
        catch (RemoteException | DynamiteModule.LoadingException throwable) {
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzpj.zzC);
            throw new MlKitException("Failed to create thin barcode scanner.", 13, throwable);
        }
        com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzpj.zza);
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final zzvt zze(DynamiteModule.VersionPolicy object, String string, String object2) throws DynamiteModule.LoadingException, RemoteException {
        object = zzvv.zza(DynamiteModule.load((Context)this.zze, (DynamiteModule.VersionPolicy)object, (String)string).instantiate(object2));
        string = ObjectWrapper.wrap((Object)this.zze);
        int n = this.zzf.zza();
        boolean bl = !this.zzf.zzd() ? this.zzf.zzb() != null : true;
        zzvl zzvl2 = new zzvl(n, bl);
        return object.zzd((IObjectWrapper)string, zzvl2);
    }
}

