/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgf;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzex
extends zzgf {
    @VisibleForTesting
    static final Pair<String, Long> zza;
    private SharedPreferences zzy;
    public zzev zzb;
    public final zzeu zzc;
    public final zzeu zzd;
    public final zzeu zze;
    public final zzeu zzf;
    public final zzeu zzg;
    public final zzeu zzh;
    public final zzeu zzi;
    public final zzew zzj;
    private String zzz;
    private boolean zzA;
    private long zzB;
    public final zzeu zzk;
    public final zzes zzl;
    public final zzew zzm;
    public final zzes zzn;
    public final zzeu zzo;
    public boolean zzp;
    public final zzes zzq;
    public final zzes zzr;
    public final zzeu zzs;
    public final zzew zzt;
    public final zzew zzu;
    public final zzeu zzv;
    public final zzet zzw;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair<String, Boolean> zzb(String string) {
        this.zzg();
        long l = this.zzx.zzax().elapsedRealtime();
        String string2 = this.zzz;
        if (string2 != null && l < this.zzB) {
            return new Pair((Object)string2, (Object)this.zzA);
        }
        this.zzB = l + this.zzx.zzc().zzj(string, zzdw.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzx.zzaw();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            if (string != null) {
                this.zzz = string.getId();
                this.zzA = string.isLimitAdTrackingEnabled();
            }
            if ((string = this.zzz) == null) {
                this.zzz = "";
            }
        }
        catch (Exception exception) {
            this.zzx.zzat().zzj().zzb("Unable to get advertising id", exception);
            this.zzz = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzz, (Object)this.zzA);
    }

    zzex(zzfl object) {
        super((zzfl)object);
        this.zzc = object = new zzeu(this, "last_upload", 0L);
        this.zzd = object = new zzeu(this, "last_upload_attempt", 0L);
        this.zze = object = new zzeu(this, "backoff", 0L);
        this.zzf = object = new zzeu(this, "last_delete_stale", 0L);
        this.zzk = object = new zzeu(this, "session_timeout", 1800000L);
        this.zzl = object = new zzes(this, "start_new_session", true);
        this.zzo = object = new zzeu(this, "last_pause_time", 0L);
        this.zzm = object = new zzew(this, "non_personalized_ads", null);
        this.zzn = object = new zzes(this, "allow_remote_dynamite", false);
        this.zzg = object = new zzeu(this, "midnight_offset", 0L);
        this.zzh = object = new zzeu(this, "first_open_time", 0L);
        this.zzi = object = new zzeu(this, "app_install_time", 0L);
        this.zzj = object = new zzew(this, "app_instance_id", null);
        this.zzq = object = new zzes(this, "app_backgrounded", false);
        this.zzr = object = new zzes(this, "deep_link_retrieval_complete", false);
        this.zzs = object = new zzeu(this, "deep_link_retrieval_attempts", 0L);
        this.zzt = object = new zzew(this, "firebase_feature_rollouts", null);
        this.zzu = object = new zzew(this, "deferred_attribution_cache", null);
        this.zzv = object = new zzeu(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzw = object = new zzet(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzay() {
        zzev zzev2;
        boolean bl;
        this.zzy = this.zzx.zzaw().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzp = bl = this.zzy.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzy.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzx.zzc();
        this.zzb = zzev2 = new zzev(this, "health_monitor", Math.max(0L, (Long)zzdw.zzb.zzb(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzd() {
        this.zzg();
        this.zzv();
        Preconditions.checkNotNull((Object)this.zzy);
        return this.zzy;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zze(Boolean bl) {
        zzex2.zzg();
        zzex zzex2 = zzex2.zzd().edit();
        if (bl != null) {
            zzex2.putBoolean("measurement_enabled", bl);
        } else {
            zzex2.remove("measurement_enabled");
        }
        zzex2.apply();
    }

    @WorkerThread
    final Boolean zzf() {
        this.zzg();
        if (this.zzd().contains("measurement_enabled")) {
            return this.zzd().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final boolean zzh(int n) {
        return zzaf.zzm(n, this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzaf zzi() {
        this.zzg();
        return zzaf.zzc(this.zzd().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final void zzj(boolean bl) {
        zzex2.zzg();
        zzex2.zzx.zzat().zzk().zzb("App measurement setting deferred collection", bl);
        zzex zzex2 = zzex2.zzd().edit();
        zzex2.putBoolean("deferred_analytics_collection", bl);
        zzex2.apply();
    }

    @WorkerThread
    final boolean zzk() {
        zzex zzex2 = zzex2.zzy;
        if (zzex2 == null) {
            return false;
        }
        return zzex2.contains("deferred_analytics_collection");
    }

    final boolean zzl(long l) {
        return l - this.zzk.zza() > this.zzo.zza();
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }
}

