/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzib;
import java.util.Map;

public final class zzd
extends zze {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb;
    private long zzc;

    public zzd(zzfl zzfl2) {
        super(zzfl2);
        super();
        this.zzb = zzfl2;
        super();
        this.zza = zzfl2;
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzx.zzat().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zza zza2 = new zza(this, string, l);
        ((zzfi)zzgg2).zzh(zza2);
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzx.zzat().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzb zzb2 = new zzb(this, string, l);
        ((zzfi)zzgg2).zzh(zzb2);
    }

    @WorkerThread
    private final void zzh(long l, zzhu zzhu2) {
        if (zzhu2 == null) {
            this.zzx.zzat().zzk().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzx.zzat().zzk().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzib.zzm(zzhu2, bundle, true);
        this.zzx.zzk().zzs("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzhu zzhu2) {
        if (zzhu2 == null) {
            this.zzx.zzat().zzk().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzx.zzat().zzk().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzib.zzm(zzhu2, bundle, true);
        this.zzx.zzk().zzs("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzc(long l) {
        zzhu zzhu2 = this.zzx.zzx().zzh(false);
        for (String string : this.zza.keySet()) {
            this.zzi(string, l - this.zza.get(string), zzhu2);
        }
        if (!this.zza.isEmpty()) {
            this.zzh(l - this.zzc, zzhu2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
            return;
        }
    }

    static /* synthetic */ void zzd(zzd zzd2, String string, long l) {
        Integer n;
        ((zzge)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        if (zzd2.zzb.isEmpty()) {
            zzd2.zzc = l;
        }
        if ((n = zzd2.zzb.get(string)) != null) {
            zzd2.zzb.put(string, n + 1);
            return;
        }
        if (zzd2.zzb.size() >= 100) {
            zzd2.zzx.zzat().zze().zza("Too many ads visible");
            return;
        }
        zzd2.zzb.put(string, 1);
        zzd2.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zze(zzd zzd2, String string, long l) {
        long l2;
        ((zzge)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Integer n = zzd2.zzb.get(string);
        if (n == null) {
            zzd2.zzx.zzat().zzb().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzhu zzhu2 = zzd2.zzx.zzx().zzh(false);
        int n2 = n + -1;
        if (n2 != 0) {
            zzd2.zzb.put(string, n2);
            return;
        }
        zzd2.zzb.remove(string);
        Long l3 = zzd2.zza.get(string);
        if (l3 == null) {
            zzd2.zzx.zzat().zzb().zza("First ad unit exposure time was never set");
        } else {
            l2 = l3;
            zzd2.zza.remove(string);
            zzd2.zzi(string, l - l2, zzhu2);
        }
        if (!zzd2.zzb.isEmpty()) {
            return;
        }
        l2 = zzd2.zzc;
        if (l2 == 0L) {
            zzd2.zzx.zzat().zzb().zza("First ad exposure time was never set");
            return;
        }
        zzd2.zzh(l - l2, zzhu2);
        zzd2.zzc = 0L;
    }

    static /* synthetic */ void zzf(zzd zzd2, long l) {
        zzd2.zzj(l);
    }
}

