/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzci;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzch
extends Fragment
implements zzcg {
    private static WeakHashMap<Activity, WeakReference<zzch>> zzfoj = new WeakHashMap();
    private Map<String, LifecycleCallback> zzfok = new ArrayMap();
    private int zzbyx = 0;
    private Bundle zzfol;

    public static zzch zzo(Activity activity) {
        zzch zzch2;
        WeakReference<zzch> weakReference = zzfoj.get(activity);
        if (weakReference != null && (zzch2 = (zzch)weakReference.get()) != null) {
            return zzch2;
        }
        try {
            zzch2 = (zzch)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzch2 == null || zzch2.isRemoving()) {
            zzch2 = new zzch();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzch2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzfoj.put(activity, new WeakReference<zzch>(zzch2));
        return zzch2;
    }

    @Override
    public final <T extends LifecycleCallback> T zza(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzfok.get(string2)));
    }

    @Override
    public final void zza(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzfok.containsKey(string2)) {
            this.zzfok.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzch zzch2 = this;
            if (zzch2.zzbyx > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzci(zzch2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final Activity zzaij() {
        return this.getActivity();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbyx = 1;
        this.zzfol = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfok.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzbyx = 2;
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzbyx = 3;
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfok.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzbyx = 4;
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzbyx = 5;
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzfok.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zza(zzch zzch2) {
        return zzch2.zzbyx;
    }

    static /* synthetic */ Bundle zzb(zzch zzch2) {
        return zzch2.zzfol;
    }
}

