/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import com.google.android.gms.signin.internal.SignInRequest;
import com.google.android.gms.signin.internal.SignInResponse;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;

public class zzg
extends zzj<zze>
implements zzxp {
    private final boolean aDv;
    private final zzf zP;
    private final Bundle aDk;
    private Integer DM;

    public zzg(Context context, Looper looper, boolean bl, zzf zzf2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.aDv = bl;
        this.zP = zzf2;
        this.aDk = bundle;
        this.DM = zzf2.zzavw();
    }

    public zzg(Context context, Looper looper, boolean bl, zzf zzf2, zzxq zzxq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, bl, zzf2, zzg.zza(zzf2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public boolean zzain() {
        return this.aDv;
    }

    @Override
    public void zza(zzp zzp2, boolean bl) {
        try {
            ((zze)this.zzavg()).zza(zzp2, this.DM, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzcdc() {
        try {
            ((zze)this.zzavg()).zzzv(this.DM);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzd zzd2) {
        zzaa.zzb((Object)zzd2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ResolveAccountRequest resolveAccountRequest = this.zzcdl();
            ((zze)this.zzavg()).zza(new SignInRequest(resolveAccountRequest), zzd2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzd2.zzb(new SignInResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    private ResolveAccountRequest zzcdl() {
        Account account = this.zP.zzave();
        GoogleSignInAccount googleSignInAccount = null;
        if ("<<default account>>".equals(account.name)) {
            googleSignInAccount = zzk.zzba(this.getContext()).zzajm();
        }
        return new ResolveAccountRequest(account, this.DM, googleSignInAccount);
    }

    protected String zzjx() {
        return "com.google.android.gms.signin.service.START";
    }

    protected String zzjy() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zze zzkx(IBinder iBinder) {
        return zze.zza.zzkw(iBinder);
    }

    protected Bundle zzahv() {
        String string2 = this.zP.zzavs();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.aDk.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zP.zzavs());
        }
        return this.aDk;
    }

    @Override
    public void connect() {
        this.zza((zze.zzf)new zze.zzi((com.google.android.gms.common.internal.zze)this));
    }

    public static Bundle zza(zzf zzf2) {
        zzxq zzxq2 = zzf2.zzavv();
        Integer n = zzf2.zzavw();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzf2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzxq2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzxq2.zzcdd());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzxq2.zzaiu());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzxq2.zzaix());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzxq2.zzaiw());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzxq2.zzaiy());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzxq2.zzcde());
            if (zzxq2.zzcdf() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzxq2.zzcdf().longValue());
            }
            if (zzxq2.zzcdg() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzxq2.zzcdg().longValue());
            }
        }
        return bundle;
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzkx(iBinder);
    }
}

