/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzrv;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class zzrh
implements Handler.Callback {
    public static final Status AG = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status AH = new Status(4, "The user must be signed in to make this API call.");
    private long Ag = 5000L;
    private long Af = 120000L;
    private long AI = 10000L;
    private static final Object zzaox = new Object();
    private static zzrh AJ;
    private final Context mContext;
    private final GoogleApiAvailability xP;
    private int AK = -1;
    private final AtomicInteger AL = new AtomicInteger(1);
    private final AtomicInteger AM = new AtomicInteger(0);
    private final Map<zzql<?>, zza<?>> zj = new ConcurrentHashMap(5, 0.75f, 1);
    private zzqw AN = null;
    private final Set<zzql<?>> AO = new com.google.android.gms.common.util.zza();
    private final Set<zzql<?>> AP = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrh zzbx(Context context) {
        Object object = zzaox;
        synchronized (object) {
            if (AJ == null) {
                AJ = new zzrh(context.getApplicationContext());
            }
            return AJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrh zzatg() {
        Object object = zzaox;
        synchronized (object) {
            zzaa.zzb((Object)AJ, (Object)"Must guarantee manager is non-null before using getInstance");
            return AJ;
        }
    }

    private zzrh(Context context) {
        this(context, GoogleApiAvailability.getInstance());
    }

    private zzrh(Context context, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        this.xP = googleApiAvailability;
    }

    public int zzath() {
        return this.AL.getAndIncrement();
    }

    public void zza(zzc<?> zzc2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, zzc2));
    }

    @WorkerThread
    private void zzb(zzc<?> zzc2) {
        zza<?> zza2;
        zzql<?> zzql2 = zzc2.getApiKey();
        if (!this.zj.containsKey(zzql2)) {
            this.zj.put(zzql2, new zza(zzc2));
        }
        if ((zza2 = this.zj.get(zzql2)).zzain()) {
            this.AP.add(zzql2);
        }
        ((zza)zza2).connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull zzqw zzqw2) {
        Object object = zzaox;
        synchronized (object) {
            if (this.AN != zzqw2) {
                this.AN = zzqw2;
                this.AO.clear();
                this.AO.addAll((Collection<zzql<?>>)zzqw2.zzasl());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(@NonNull zzqw zzqw2) {
        Object object = zzaox;
        synchronized (object) {
            if (this.AN == zzqw2) {
                this.AN = null;
                this.AO.clear();
            }
        }
    }

    public Task<Void> zza(Iterable<zzc<?>> iterable) {
        zzqn zzqn2 = new zzqn(iterable);
        for (zzc<? extends Api.ApiOptions> zzc2 : iterable) {
            zza<?> zza2 = this.zj.get(zzc2.getApiKey());
            if (zza2 != null && zza2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)zzqn2));
            return zzqn2.getTask();
        }
        zzqn2.zzarp();
        return zzqn2.getTask();
    }

    @WorkerThread
    public void zza(zzqn zzqn2) {
        Set<zzql<?>> set = zzqn2.zzaro();
        for (zzql<?> zzql2 : set) {
            zza<?> zza2 = this.zj.get(zzql2);
            if (zza2 == null) {
                ConnectionResult connectionResult = new ConnectionResult(13);
                zzqn2.zza(zzql2, connectionResult);
                return;
            }
            if (zza2.isConnected()) {
                zzqn2.zza(zzql2, ConnectionResult.wO);
                continue;
            }
            if (zza2.zzatp() != null) {
                zzqn2.zza(zzql2, zza2.zzatp());
                continue;
            }
            zza2.zzb(zzqn2);
        }
    }

    public void zzarm() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    @WorkerThread
    private void zzati() {
        for (zza<?> zza2 : this.zj.values()) {
            zza2.zzato();
            ((zza)zza2).connect();
        }
    }

    @WorkerThread
    public void zzatj() {
        for (zzql<?> zzql2 : this.AP) {
            this.zj.remove(zzql2).signOut();
        }
        this.AP.clear();
    }

    public <O extends Api.ApiOptions> void zza(zzc<O> zzc2, int n, zzqo.zza<? extends Result, Api.zzb> zza2) {
        zzqj.zzb<zzqo.zza<? extends Result, Api.zzb>> zzb2 = new zzqj.zzb<zzqo.zza<? extends Result, Api.zzb>>(n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)new zzrv(zzb2, this.AM.get(), zzc2)));
    }

    public <O extends Api.ApiOptions, TResult> void zza(zzc<O> zzc2, int n, zzse<Api.zzb, TResult> zzse2, TaskCompletionSource<TResult> taskCompletionSource, zzsb zzsb2) {
        zzqj.zzd<TResult> zzd2 = new zzqj.zzd<TResult>(n, zzse2, taskCompletionSource, zzsb2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)new zzrv(zzd2, this.AM.get(), zzc2)));
    }

    @WorkerThread
    private void zza(zzrv zzrv2) {
        zza<?> zza2 = this.zj.get(zzrv2.Bs.getApiKey());
        if (zza2 == null) {
            this.zzb(zzrv2.Bs);
            zza2 = this.zj.get(zzrv2.Bs.getApiKey());
        }
        if (zza2.zzain() && this.AM.get() != zzrv2.Br) {
            zzrv2.Bq.zzy(AG);
            zza2.signOut();
            return;
        }
        zza2.zza(zzrv2.Bq);
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzrw<Api.zzb> zzrw2, @NonNull zzsh<Api.zzb> zzsh2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzqj.zzc zzc3 = new zzqj.zzc(new zzrx(zzrw2, zzsh2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, (Object)new zzrv(zzc3, this.AM.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzrr.zzb<?> zzb2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzqj.zze zze2 = new zzqj.zze(zzb2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(11, (Object)new zzrv(zze2, this.AM.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zza((zzqn)message.obj);
                break;
            }
            case 5: {
                this.zzb((zzc)message.obj);
                break;
            }
            case 2: {
                this.zzati();
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                this.zza((zzrv)message.obj);
                break;
            }
            case 4: {
                this.zza(message.arg1, (ConnectionResult)message.obj);
                break;
            }
            case 7: {
                if (!this.zj.containsKey(message.obj)) break;
                ((zza)this.zj.get(message.obj)).resume();
                break;
            }
            case 8: {
                this.zzatj();
                break;
            }
            case 9: {
                if (!this.zj.containsKey(message.obj)) break;
                ((zza)this.zj.get(message.obj)).zzasx();
                break;
            }
            case 10: {
                if (!this.zj.containsKey(message.obj)) break;
                ((zza)this.zj.get(message.obj)).zzats();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        if (connectionResult.hasResolution() || this.xP.isUserResolvableError(connectionResult.getErrorCode())) {
            this.xP.zza(this.mContext, connectionResult, n);
            return true;
        }
        return false;
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, n, 0, (Object)connectionResult));
        }
    }

    @WorkerThread
    private void zza(int n, ConnectionResult connectionResult) {
        zza<?> zza2 = null;
        for (zza<?> zza3 : this.zj.values()) {
            if (zza3.getInstanceId() != n) continue;
            zza2 = zza3;
            break;
        }
        if (zza2 != null) {
            zza<?> zza3;
            String string2 = String.valueOf(this.xP.getErrorString(connectionResult.getErrorCode()));
            zza3 = String.valueOf(connectionResult.getErrorMessage());
            ((zza)zza2).zzac(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zza3).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zza3)).toString()));
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
        }
    }

    private class zzb
    implements zze.zzf {
        private final Api.zze xB;
        private final zzql<?> xx;

        public zzb(Api.zze zze2, zzql<?> zzql2) {
            this.xB = zze2;
            this.xx = zzql2;
        }

        @WorkerThread
        public void zzg(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                if (!this.xB.zzain()) {
                    this.xB.zza(null, Collections.emptySet());
                }
            } else {
                ((zza)zzrh.this.zj.get(this.xx)).onConnectionFailed(connectionResult);
            }
        }
    }

    class zza<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zzqs {
        private final Queue<zzqj> AQ = new LinkedList<zzqj>();
        private final Api.zze xB;
        private final Api.zzb AR;
        private final zzql<O> xx;
        private final zzqv AS;
        private final Set<zzqn> AT = new HashSet<zzqn>();
        private final Map<zzrr.zzb<?>, zzrx> AU = new HashMap();
        private final int AV;
        private boolean Ae;
        private ConnectionResult AW = null;

        @WorkerThread
        public zza(zzc<O> zzc2) {
            if (zzc2.isConnectionlessGoogleApiClient()) {
                this.xB = zzc2.getClient();
                zzc2.getClientCallbacks().zza(this);
            } else {
                this.xB = zzc2.buildApiClient(zzrh.this.mHandler.getLooper(), this, this);
            }
            this.AR = this.xB instanceof zzag ? ((zzag)this.xB).zzawt() : this.xB;
            this.xx = zzc2.getApiKey();
            this.AS = new zzqv();
            this.AV = zzc2.getInstanceId();
        }

        @Override
        @WorkerThread
        public void onConnected(@Nullable Bundle bundle) {
            this.zzato();
            this.zzi(ConnectionResult.wO);
            this.zzatq();
            for (zzrx zzrx2 : this.AU.values()) {
                try {
                    zzrx2.yi.zza(this.AR, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.xB.disconnect();
                }
            }
            this.zzatm();
            this.zzatr();
        }

        @Override
        @WorkerThread
        public void onConnectionSuspended(int n) {
            this.zzato();
            this.Ae = true;
            this.AS.zzask();
            zzrh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzrh.this.mHandler, (int)7, this.xx), zzrh.this.Ag);
            zzrh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzrh.this.mHandler, (int)9, this.xx), zzrh.this.Af);
            zzrh.this.AK = -1;
        }

        @Override
        public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zzato();
            zzrh.this.AK = -1;
            this.zzi(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zzac(AH);
                return;
            }
            if (this.AQ.isEmpty()) {
                this.AW = connectionResult;
                return;
            }
            Object object = zzaox;
            synchronized (object) {
                if (zzrh.this.AN != null && zzrh.this.AO.contains(this.xx)) {
                    zzrh.this.AN.zzb(connectionResult, this.AV);
                    return;
                }
            }
            if (!zzrh.this.zzc(connectionResult, this.AV)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.Ae = true;
                }
                if (this.Ae) {
                    zzrh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzrh.this.mHandler, (int)7, this.xx), zzrh.this.Ag);
                } else {
                    object = String.valueOf(this.xx.zzarl());
                    this.zzac(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        public void zzatm() {
            while (this.xB.isConnected() && !this.AQ.isEmpty()) {
                zzqj zzqj2 = this.AQ.remove();
                this.zzb(zzqj2);
            }
        }

        @WorkerThread
        public void zza(zzqj zzqj2) {
            if (this.xB.isConnected()) {
                this.zzb(zzqj2);
                this.zzatr();
            } else {
                this.AQ.add(zzqj2);
                if (this.AW != null && this.AW.hasResolution()) {
                    this.onConnectionFailed(this.AW);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void signOut() {
            this.zzac(AG);
            this.AS.zzasj();
            for (zzrr.zzb<?> zzb2 : this.AU.keySet()) {
                this.zza(new zzqj.zze(zzb2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
            }
            this.xB.disconnect();
        }

        public Api.zze getClient() {
            return this.xB;
        }

        public Map<zzrr.zzb<?>, zzrx> zzatn() {
            return this.AU;
        }

        @WorkerThread
        public void zzato() {
            this.AW = null;
        }

        ConnectionResult zzatp() {
            return this.AW;
        }

        @WorkerThread
        private void zzb(zzqj zzqj2) {
            zzqj2.zza(this.AS, this.zzain());
            try {
                zzqj2.zza(this);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.xB.disconnect();
            }
        }

        @WorkerThread
        private void zzac(Status status) {
            for (zzqj zzqj2 : this.AQ) {
                zzqj2.zzy(status);
            }
            this.AQ.clear();
        }

        @WorkerThread
        private void resume() {
            if (this.Ae) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzatq() {
            if (this.Ae) {
                zzrh.this.mHandler.removeMessages(9, this.xx);
                zzrh.this.mHandler.removeMessages(7, this.xx);
                this.Ae = false;
            }
        }

        @WorkerThread
        private void zzasx() {
            if (this.Ae) {
                this.zzatq();
                int n = zzrh.this.xP.isGooglePlayServicesAvailable(zzrh.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzac(status);
                this.xB.disconnect();
            }
        }

        private void zzatr() {
            zzrh.this.mHandler.removeMessages(10, this.xx);
            zzrh.this.mHandler.sendMessageDelayed(zzrh.this.mHandler.obtainMessage(10, this.xx), zzrh.this.AI);
        }

        private void zzats() {
            if (this.xB.isConnected() && this.AU.size() == 0) {
                if (this.AS.zzasi()) {
                    this.zzatr();
                    return;
                }
                this.xB.disconnect();
            }
        }

        @WorkerThread
        private void connect() {
            if (this.xB.isConnected() || this.xB.isConnecting()) {
                return;
            }
            if (this.xB.zzaqx() && zzrh.this.AK != 0) {
                zzrh.this.AK = zzrh.this.xP.isGooglePlayServicesAvailable(zzrh.this.mContext);
                if (zzrh.this.AK != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzrh.this.AK, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            if (this.xB.zzain()) {
                // empty if block
            }
            zzb zzb2 = new zzb(this.xB, this.xx);
            this.xB.zza(zzb2);
        }

        @WorkerThread
        public void zzb(zzqn zzqn2) {
            this.AT.add(zzqn2);
        }

        @WorkerThread
        private void zzi(ConnectionResult connectionResult) {
            for (zzqn zzqn2 : this.AT) {
                zzqn2.zza(this.xx, connectionResult);
            }
            this.AT.clear();
        }

        boolean isConnected() {
            return this.xB.isConnected();
        }

        public boolean zzain() {
            return this.xB.zzain();
        }

        public int getInstanceId() {
            return this.AV;
        }
    }
}

