/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope hd = new Scope("profile");
    public static final Scope he = new Scope("email");
    public static final Scope hf = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> hg;
    private Account ec;
    private boolean hh;
    private final boolean hi;
    private final boolean hj;
    private String hk;
    private String hl;
    private static Comparator<Scope> hc = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzaqg().compareTo(scope2.zzaqg());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzfy(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.hg = arrayList;
        this.ec = account;
        this.hh = bl;
        this.hi = bl2;
        this.hj = bl3;
        this.hk = string2;
        this.hl = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzahj() {
        return new ArrayList<Scope>(this.hg);
    }

    public Scope[] getScopeArray() {
        return this.hg.toArray(new Scope[this.hg.size()]);
    }

    public Account getAccount() {
        return this.ec;
    }

    public boolean zzahk() {
        return this.hh;
    }

    public boolean zzahl() {
        return this.hi;
    }

    public boolean zzahm() {
        return this.hj;
    }

    public String zzahn() {
        return this.hk;
    }

    public String zzaho() {
        return this.hl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.hg.size() != googleSignInOptions.zzahj().size() || !this.hg.containsAll(googleSignInOptions.zzahj())) {
                return false;
            }
            return (this.ec == null ? googleSignInOptions.getAccount() == null : this.ec.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.hk) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzahn()) : this.hk.equals(googleSignInOptions.zzahn())) && this.hj == googleSignInOptions.zzahm() && this.hh == googleSignInOptions.zzahk() && this.hi == googleSignInOptions.zzahl();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.hg) {
            arrayList.add(scope.zzaqg());
        }
        Collections.sort(arrayList);
        return new zze().zzq(arrayList).zzq(this.ec).zzq(this.hk).zzbd(this.hj).zzbd(this.hh).zzbd(this.hi).zzahv();
    }

    public String zzahg() {
        return this.zzahi().toString();
    }

    private JSONObject zzahi() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.hg, hc);
            for (Scope scope : this.hg) {
                jSONArray.put((Object)scope.zzaqg());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.ec != null) {
                jSONObject.put("accountName", (Object)this.ec.name);
            }
            jSONObject.put("idTokenRequested", this.hh);
            jSONObject.put("forceCodeForRefreshToken", this.hj);
            jSONObject.put("serverAuthRequested", this.hi);
            if (!TextUtils.isEmpty((CharSequence)this.hk)) {
                jSONObject.put("serverClientId", (Object)this.hk);
            }
            if (!TextUtils.isEmpty((CharSequence)this.hl)) {
                jSONObject.put("hostedDomain", (Object)this.hl);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> hm = new HashSet<Scope>();
        private boolean hi;
        private boolean hj;
        private boolean hh;
        private String hk;
        private Account ec;
        private String hl;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzac.zzy((Object)googleSignInOptions);
            this.hm = new HashSet<Scope>(googleSignInOptions.hg);
            this.hi = googleSignInOptions.hi;
            this.hj = googleSignInOptions.hj;
            this.hh = googleSignInOptions.hh;
            this.hk = googleSignInOptions.hk;
            this.ec = googleSignInOptions.ec;
            this.hl = googleSignInOptions.hl;
        }

        public Builder requestId() {
            this.hm.add(hf);
            return this;
        }

        public Builder requestEmail() {
            this.hm.add(he);
            return this;
        }

        public Builder requestProfile() {
            this.hm.add(hd);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.hm.add(scope);
            this.hm.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.hh = true;
            this.hk = this.zzfz(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.hi = true;
            this.hk = this.zzfz(string2);
            this.hj = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.ec = new Account(zzac.zzhz((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.hl = zzac.zzhz((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.hh && (this.ec == null || !this.hm.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.hm, this.ec, this.hh, this.hi, this.hj, this.hk, this.hl);
        }

        private String zzfz(String string2) {
            zzac.zzhz((String)string2);
            zzac.zzb((this.hk == null || this.hk.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

