/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zza();
    public static zze gT = zzh.zzaxj();
    final int versionCode;
    private String zzbks;
    private String gs;
    private String gU;
    private String gV;
    private Uri gW;
    private String gX;
    private long gY;
    private String gZ;
    List<Scope> fK;
    private String ha;
    private String hb;
    private static Comparator<Scope> hc = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzaqg().compareTo(scope2.zzaqg());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInAccount zzfw(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzfx(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = gT.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzac.zzhz((String)string8), new ArrayList<Scope>((Collection)zzac.zzy(set)), string6, string7);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzbks = string2;
        this.gs = string3;
        this.gU = string4;
        this.gV = string5;
        this.gW = uri;
        this.gX = string6;
        this.gY = l;
        this.gZ = string7;
        this.fK = list;
        this.ha = string8;
        this.hb = string9;
    }

    @Nullable
    public String getId() {
        return this.zzbks;
    }

    @Nullable
    public String getIdToken() {
        return this.gs;
    }

    @Nullable
    public String getEmail() {
        return this.gU;
    }

    @Nullable
    public String getDisplayName() {
        return this.gV;
    }

    @Nullable
    public String getGivenName() {
        return this.ha;
    }

    @Nullable
    public String getFamilyName() {
        return this.hb;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.gW;
    }

    public GoogleSignInAccount zzfx(String string2) {
        this.gX = string2;
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.gX;
    }

    public long zzahe() {
        return this.gY;
    }

    public boolean zza() {
        return gT.currentTimeMillis() / 1000L >= this.gY - 300L;
    }

    @NonNull
    public String zzahf() {
        return this.gZ;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.fK);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return this.zzahg().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzahg().equals(this.zzahg());
    }

    public String zzahg() {
        return this.zzahi().toString();
    }

    public String zzahh() {
        JSONObject jSONObject = this.zzahi();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzahi() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.gY);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzahf());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.fK, hc);
            for (Scope scope : this.fK) {
                jSONArray.put((Object)scope.zzaqg());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

