/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzpq
implements zzqh {
    private final Context mContext;
    private final zzpy th;
    private final Looper zzahv;
    private final zzqa ti;
    private final zzqa tj;
    private final Map<Api.zzc<?>, zzqa> tk;
    private final Set<zzqt> tl = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze tm;
    private Bundle tn;
    private ConnectionResult to = null;
    private ConnectionResult tp = null;
    private boolean tq = false;
    private final Lock tr;
    private int ts = 0;

    public static zzpq zza(Context context, zzpy zzpy2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzvu, zzvv> zza2, ArrayList<zzpp> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzafz()) {
                zze2 = object;
            }
            if (object.zzafk()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzab.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzans();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzpp>();
        ArrayList<zzpp> arrayList2 = new ArrayList<zzpp>();
        for (zzpp zzpp2 : arrayList) {
            if (arrayMap5.containsKey(zzpp2.pN)) {
                ((ArrayList)object).add(zzpp2);
                continue;
            }
            if (arrayMap.containsKey(zzpp2.pN)) {
                arrayList2.add(zzpp2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zzpq(context, zzpy2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzg2, zza2, zze2, (ArrayList<zzpp>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zzpq(Context context, zzpy zzpy2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzg zzg2, Api.zza<? extends zzvu, zzvv> zza2, Api.zze zze2, ArrayList<zzpp> arrayList, ArrayList<zzpp> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.th = zzpy2;
        this.tr = lock;
        this.zzahv = looper;
        this.tm = zze2;
        this.ti = new zzqa(context, this.th, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.tj = new zzqa(context, this.th, lock, looper, zzc2, map, zzg2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.ti);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.tj);
        }
        this.tk = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpm.zza<R, A>> T zzc(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzaph()) {
                t.zzz(new Status(4, null, this.zzapi()));
                return t;
            }
            return this.tj.zzc(t);
        }
        return this.ti.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzd(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzaph()) {
                t.zzz(new Status(4, null, this.zzapi()));
                return t;
            }
            return this.tj.zzd(t);
        }
        return this.ti.zzd(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.tk.get(api.zzans()).equals(this.tj)) {
            if (this.zzaph()) {
                return new ConnectionResult(4, this.zzapi());
            }
            return this.tj.getConnectionResult(api);
        }
        return this.ti.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.ts = 2;
        this.tq = false;
        this.zzapd();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.tp = null;
        this.to = null;
        this.ts = 0;
        this.ti.disconnect();
        this.tj.disconnect();
        this.zzapg();
    }

    @Override
    public boolean isConnected() {
        this.tr.lock();
        try {
            boolean bl = this.ti.isConnected() && (this.zzapc() || this.zzaph() || this.ts == 1);
            return bl;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.tr.lock();
        try {
            boolean bl = this.ts == 2;
            return bl;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public boolean zza(zzqt zzqt2) {
        this.tr.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzapc()) {
                this.tl.add(zzqt2);
                if (this.ts == 0) {
                    this.ts = 1;
                }
                this.tp = null;
                this.tj.connect();
                boolean bl = true;
                return true;
            }
        }
        finally {
            this.tr.unlock();
        }
        return false;
    }

    @Override
    public void zzapb() {
        this.ti.zzapb();
        this.tj.zzapb();
    }

    @Override
    public void zzaof() {
        this.tr.lock();
        try {
            boolean bl = this.isConnecting();
            this.tj.disconnect();
            this.tp = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzahv);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzpq.this.tr.lock();
                        try {
                            zzpq.this.zzape();
                        }
                        finally {
                            zzpq.this.tr.unlock();
                        }
                    }
                });
            } else {
                this.zzapg();
            }
        }
        finally {
            this.tr.unlock();
        }
    }

    public boolean zzapc() {
        return this.tj.isConnected();
    }

    private void zzapd() {
        this.tp = null;
        this.to = null;
        this.ti.connect();
        this.tj.connect();
    }

    private void zzape() {
        if (zzpq.zzc(this.to)) {
            if (zzpq.zzc(this.tp) || this.zzaph()) {
                this.zzapf();
            } else if (this.tp != null) {
                if (this.ts == 1) {
                    this.zzapg();
                } else {
                    this.zzb(this.tp);
                    this.ti.disconnect();
                }
            }
        } else if (this.to != null && zzpq.zzc(this.tp)) {
            this.tj.disconnect();
            this.zzb(this.to);
        } else if (this.to != null && this.tp != null) {
            ConnectionResult connectionResult = this.to;
            if (this.tj.uA < this.ti.uA) {
                connectionResult = this.tp;
            }
            this.zzb(connectionResult);
        }
    }

    private void zzapf() {
        switch (this.ts) {
            case 2: {
                this.th.zzm(this.tn);
            }
            case 1: {
                this.zzapg();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.ts = 0;
    }

    private void zzb(ConnectionResult connectionResult) {
        switch (this.ts) {
            case 2: {
                this.th.zzd(connectionResult);
            }
            case 1: {
                this.zzapg();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.ts = 0;
    }

    private void zzapg() {
        for (zzqt zzqt2 : this.tl) {
            zzqt2.zzafy();
        }
        this.tl.clear();
    }

    private void zzb(int n, boolean bl) {
        this.th.zzc(n, bl);
        this.tp = null;
        this.to = null;
    }

    private boolean zzaph() {
        return this.tp != null && this.tp.getErrorCode() == 4;
    }

    private boolean zze(zzpm.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzans();
        zzab.zzb((boolean)this.tk.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.tk.get(zzc2).equals(this.tj);
    }

    @Nullable
    private PendingIntent zzapi() {
        if (this.tm == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.th.getSessionId(), (Intent)this.tm.zzaga(), (int)0x8000000);
    }

    private void zzl(Bundle bundle) {
        if (this.tn == null) {
            this.tn = bundle;
        } else if (bundle != null) {
            this.tn.putAll(bundle);
        }
    }

    private static boolean zzc(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.tj.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.ti.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzqh.zza {
        private zzb() {
        }

        @Override
        public void zzm(@Nullable Bundle bundle) {
            zzpq.this.tr.lock();
            try {
                zzpq.this.tp = ConnectionResult.rb;
                zzpq.this.zzape();
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzpq.this.tr.lock();
            try {
                zzpq.this.tp = connectionResult;
                zzpq.this.zzape();
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzpq.this.tr.lock();
            try {
                if (zzpq.this.tq) {
                    zzpq.this.tq = false;
                    zzpq.this.zzb(n, bl);
                    return;
                }
                zzpq.this.tq = true;
                zzpq.this.ti.onConnectionSuspended(n);
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }
    }

    private class zza
    implements zzqh.zza {
        private zza() {
        }

        @Override
        public void zzm(@Nullable Bundle bundle) {
            zzpq.this.tr.lock();
            try {
                zzpq.this.zzl(bundle);
                zzpq.this.to = ConnectionResult.rb;
                zzpq.this.zzape();
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzpq.this.tr.lock();
            try {
                zzpq.this.to = connectionResult;
                zzpq.this.zzape();
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzpq.this.tr.lock();
            try {
                if (zzpq.this.tq || zzpq.this.tp == null || !zzpq.this.tp.isSuccess()) {
                    zzpq.this.tq = false;
                    zzpq.this.zzb(n, bl);
                    return;
                }
                zzpq.this.tq = true;
                zzpq.this.tj.onConnectionSuspended(n);
            }
            finally {
                zzpq.this.tr.unlock();
            }
        }
    }
}

