/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzpk
extends zzpn {
    private final SparseArray<zza> sC = new SparseArray();

    public static zzpk zza(zzqi zzqi2) {
        zzqk zzqk2 = zzpk.zzc((zzqi)zzqi2);
        zzpk zzpk2 = (zzpk)zzqk2.zza("AutoManageHelper", zzpk.class);
        if (zzpk2 != null) {
            return zzpk2;
        }
        return new zzpk(zzqk2);
    }

    private zzpk(zzqk zzqk2) {
        super(zzqk2);
        this.vm.zza("AutoManageHelper", (zzqj)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzab.zza((this.sC.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.sL;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.sC.put(n, (Object)zza2);
        if (this.mStarted && !this.sL) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzfh(int n) {
        zza zza2 = (zza)this.sC.get(n);
        this.sC.remove(n);
        if (zza2 != null) {
            zza2.zzaop();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.sC);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.sL) {
            for (n = 0; n < this.sC.size(); ++n) {
                object = (zza)this.sC.valueAt(n);
                ((zza)object).sE.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.sC.size(); ++i) {
            zza zza2 = (zza)this.sC.valueAt(i);
            zza2.sE.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.sC.size(); ++i) {
            zza zza2 = (zza)this.sC.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.sC.get(n);
        if (zza2 != null) {
            this.zzfh(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.sF;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzaoo() {
        for (int i = 0; i < this.sC.size(); ++i) {
            zza zza2 = (zza)this.sC.valueAt(i);
            zza2.sE.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int sD;
        public final GoogleApiClient sE;
        public final GoogleApiClient.OnConnectionFailedListener sF;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.sD = n;
            this.sE = googleApiClient;
            this.sF = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzpk.this.zzb(connectionResult, this.sD);
        }

        public void zzaop() {
            this.sE.unregisterConnectionFailedListener(this);
            this.sE.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.sD);
            printWriter.println(":");
            this.sE.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

