/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl
implements Handler.Callback {
    private final zza yE;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> yF = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> yG = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> yH = new ArrayList();
    private volatile boolean yI = false;
    private final AtomicInteger yJ = new AtomicInteger(0);
    private boolean yK = false;
    private final Handler mHandler;
    private final Object zzail = new Object();

    public zzl(Looper looper, zza zza2) {
        this.yE = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzasw() {
        this.yI = false;
        this.yJ.incrementAndGet();
    }

    public void zzasx() {
        this.yI = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzo(Bundle bundle) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzail;
        synchronized (object) {
            zzab.zzbn((!this.yK ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.yK = true;
            zzab.zzbn((this.yG.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.yF);
            int n = this.yJ.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.yI || !this.yE.isConnected() || this.yJ.get() != n) break;
                if (this.yG.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.yG.clear();
            this.yK = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgf(int n) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzail;
        synchronized (object) {
            this.yK = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.yF);
            int n2 = this.yJ.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.yI || this.yJ.get() != n2) break;
                if (!this.yF.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.yG.clear();
            this.yK = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(ConnectionResult connectionResult) {
        zzab.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzail;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.yH);
            int n = this.yJ.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.yI || this.yJ.get() != n) {
                    return;
                }
                if (!this.yH.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzy((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            if (this.yF.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.yF.add(connectionCallbacks);
            }
        }
        if (this.yE.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzy((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            return this.yF.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzab.zzy((Object)connectionCallbacks);
        Object object = this.zzail;
        synchronized (object) {
            boolean bl = this.yF.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.yK) {
                this.yG.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzy((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            if (this.yH.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.yH.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzy((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            return this.yH.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzy((Object)onConnectionFailedListener);
        Object object = this.zzail;
        synchronized (object) {
            boolean bl = this.yH.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzail;
            synchronized (object) {
                if (this.yI && this.yE.isConnected() && this.yF.contains(connectionCallbacks)) {
                    Bundle bundle = this.yE.zzamh();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzamh();
    }
}

