/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.dynamic.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int mSize;
    private int mColor;
    private Scope[] ry;
    private View rz;
    private View.OnClickListener rA = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzb(context, attributeSet);
        this.setStyle(this.mSize, this.mColor, this.ry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.SignInButton, 0, 0);
        try {
            this.mSize = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.mColor = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
            String string2 = typedArray.getString(R.styleable.SignInButton_scopeUris);
            if (string2 == null) {
                this.ry = null;
            } else {
                String[] stringArray = string2.trim().split("\\s+");
                this.ry = new Scope[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.ry[i] = new Scope(stringArray[i].toString());
                }
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSize(int n) {
        this.setStyle(n, this.mColor, this.ry);
    }

    public void setColorScheme(int n) {
        this.setStyle(this.mSize, n, this.ry);
    }

    public void setScopes(Scope[] scopeArray) {
        this.setStyle(this.mSize, this.mColor, scopeArray);
    }

    public void setStyle(int n, int n2) {
        this.setStyle(n, n2, this.ry);
    }

    public void setStyle(int n, int n2, Scope[] scopeArray) {
        this.mSize = n;
        this.mColor = n2;
        this.ry = scopeArray;
        this.zzca(this.getContext());
    }

    private void zzca(Context context) {
        if (this.rz != null) {
            this.removeView(this.rz);
        }
        try {
            this.rz = zzaf.zzb(context, this.mSize, this.mColor, this.ry);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.rz = SignInButton.zza(context, this.mSize, this.mColor, this.ry);
        }
        this.addView(this.rz);
        this.rz.setEnabled(this.isEnabled());
        this.rz.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2, Scope[] scopeArray) {
        zzag zzag2 = new zzag(context);
        zzag2.zza(context.getResources(), n, n2, scopeArray);
        return zzag2;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.rA = onClickListener;
        if (this.rz != null) {
            this.rz.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.rz.setEnabled(bl);
    }

    public void onClick(View view) {
        if (this.rA != null && view == this.rz) {
            this.rA.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

