/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    private final int mVersionCode;
    private final String[] vO;
    Bundle vP;
    private final CursorWindow[] vQ;
    private final int ob;
    private final Bundle vR;
    int[] vS;
    int vT;
    boolean mClosed = false;
    private Object vU;
    private boolean vV = true;
    private static final zza vW = new zza(new String[0], null){

        @Override
        public zza zza(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.vO = stringArray;
        this.vQ = cursorWindowArray;
        this.ob = n2;
        this.vR = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.mVersionCode = 1;
        this.vO = (String[])zzab.zzaa((Object)stringArray);
        this.vQ = (CursorWindow[])zzab.zzaa((Object)cursorWindowArray);
        this.ob = n;
        this.vR = bundle;
        this.zzard();
    }

    public void zzv(Object object) {
        this.vU = object;
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.vO, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzard() {
        int n;
        this.vP = new Bundle();
        for (n = 0; n < this.vO.length; ++n) {
            this.vP.putInt(this.vO[n], n);
        }
        this.vS = new int[this.vQ.length];
        n = 0;
        for (int i = 0; i < this.vQ.length; ++i) {
            this.vS[i] = n;
            int n2 = this.vQ[i].getStartPosition();
            int n3 = n - n2;
            n += this.vQ[i].getNumRows() - n3;
        }
        this.vT = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    String[] zzare() {
        return this.vO;
    }

    CursorWindow[] zzarf() {
        return this.vQ;
    }

    public int getStatusCode() {
        return this.ob;
    }

    public Bundle zzaqy() {
        return this.vR;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.vO.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.vX.size() ? zza2.vX : zza2.vX.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.vO.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.vO.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.vO.length && bl2; ++n3) {
                    String string2 = zza2.vO[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.vO.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzh(String string2, int n) {
        if (this.vP == null || !this.vP.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.vT) {
            throw new CursorIndexOutOfBoundsException(n, this.vT);
        }
    }

    public boolean zzhf(String string2) {
        return this.vP.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].getLong(n, this.vP.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].getInt(n, this.vP.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].getString(n, this.vP.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzh(string2, n);
        Long l = this.vQ[n2].getLong(n, this.vP.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].getFloat(n, this.vP.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].getBlob(n, this.vP.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzh(string2, n);
        this.vQ[n2].copyStringToBuffer(n, this.vP.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.vQ[n2].isNull(n, this.vP.getInt(string2));
    }

    public int getCount() {
        return this.vT;
    }

    public int zzfo(int n) {
        int n2;
        zzab.zzbm((n >= 0 && n < this.vT ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.vS.length; ++n2) {
            if (n >= this.vS[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.vS.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.vQ.length; ++i) {
                    this.vQ[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.vV && this.vQ.length > 0 && !this.isClosed()) {
                String string2;
                if (this.vU == null) {
                    String string3 = String.valueOf(this.toString());
                    string2 = string3.length() != 0 ? "internal object: ".concat(string3) : new String("internal object: ");
                } else {
                    string2 = this.vU.toString();
                }
                String string4 = string2;
                Log.e((String)"DataBuffer", (String)new StringBuilder(161 + String.valueOf(string4).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (").append(string4).append(")").toString());
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzb(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzfp(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(vW, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] vO;
        private final ArrayList<HashMap<String, Object>> vX;
        private final String vY;
        private final HashMap<Object, Integer> vZ;
        private boolean wa;
        private String wb;

        private zza(String[] stringArray, String string2) {
            this.vO = (String[])zzab.zzaa((Object)stringArray);
            this.vX = new ArrayList();
            this.vY = string2;
            this.vZ = new HashMap();
            this.wa = false;
            this.wb = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            com.google.android.gms.common.internal.zzb.zzw(hashMap);
            int n = this.zzb(hashMap);
            if (n == -1) {
                this.vX.add(hashMap);
            } else {
                this.vX.remove(n);
                this.vX.add(n, hashMap);
            }
            this.wa = false;
            return this;
        }

        private int zzb(HashMap<String, Object> hashMap) {
            if (this.vY == null) {
                return -1;
            }
            Object object = hashMap.get(this.vY);
            if (object == null) {
                return -1;
            }
            Integer n = this.vZ.get(object);
            if (n == null) {
                this.vZ.put(object, this.vX.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            com.google.android.gms.common.internal.zzb.zzw((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public DataHolder zzfq(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

