/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;

public abstract class zzps
extends zzqo
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean sB;
    private ConnectionResult sC;
    private int sD = -1;
    private final Handler sE = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability rX;

    protected zzps(zzqp zzqp2) {
        this(zzqp2, GoogleApiAvailability.getInstance());
    }

    zzps(zzqp zzqp2, GoogleApiAvailability googleApiAvailability) {
        super(zzqp2);
        this.rX = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.sD);
        this.zzaoq();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.sB = bundle.getBoolean("resolving_error", false);
            if (this.sB) {
                this.sD = bundle.getInt("failed_client_id", -1);
                this.sC = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.sB);
        if (this.sB) {
            bundle.putInt("failed_client_id", this.sD);
            bundle.putInt("failed_status", this.sC.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.sC.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.rX.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.sC.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.sC = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzaoq();
        } else {
            this.zza(this.sC, this.sD);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzaol();

    protected void zzaoq() {
        this.sD = -1;
        this.sB = false;
        this.sC = null;
        this.zzaol();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.sB) {
            this.sB = true;
            this.sD = n;
            this.sC = connectionResult;
            this.sE.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzps.this.mStarted) {
                return;
            }
            if (zzps.this.sC.hasResolution()) {
                zzps.this.va.startActivityForResult(GoogleApiActivity.zzb((Context)zzps.this.getActivity(), zzps.this.sC.getResolution(), zzps.this.sD, false), 1);
            } else if (zzps.this.rX.isUserResolvableError(zzps.this.sC.getErrorCode())) {
                zzps.this.rX.zza(zzps.this.getActivity(), zzps.this.va, zzps.this.sC.getErrorCode(), 2, zzps.this);
            } else if (zzps.this.sC.getErrorCode() == 18) {
                final Dialog dialog = zzps.this.rX.zza(zzps.this.getActivity(), zzps.this);
                zzps.this.rX.zza(zzps.this.getActivity().getApplicationContext(), new zzqj.zza(){

                    @Override
                    public void zzaor() {
                        zzps.this.zzaoq();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzps.this.zza(zzps.this.sC, zzps.this.sD);
            }
        }
    }
}

