/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.dynamic.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int mSize;
    private int mColor;
    private Scope[] zzakD;
    private View zzakE;
    private View.OnClickListener zzakF = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zza(context, attributeSet);
        this.setStyle(this.mSize, this.mColor, this.zzakD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.SignInButton, 0, 0);
        try {
            this.mSize = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.mColor = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
            String string2 = typedArray.getString(R.styleable.SignInButton_scopeUris);
            if (string2 == null) {
                this.zzakD = null;
            } else {
                String[] stringArray = string2.trim().split("\\s+");
                this.zzakD = new Scope[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.zzakD[i] = new Scope(stringArray[i].toString());
                }
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSize(int n) {
        this.setStyle(n, this.mColor, this.zzakD);
    }

    public void setColorScheme(int n) {
        this.setStyle(this.mSize, n, this.zzakD);
    }

    public void setScopes(Scope[] scopeArray) {
        this.setStyle(this.mSize, this.mColor, scopeArray);
    }

    public void setStyle(int n, int n2) {
        this.setStyle(n, n2, this.zzakD);
    }

    public void setStyle(int n, int n2, Scope[] scopeArray) {
        this.mSize = n;
        this.mColor = n2;
        this.zzakD = scopeArray;
        this.zzar(this.getContext());
    }

    private void zzar(Context context) {
        if (this.zzakE != null) {
            this.removeView(this.zzakE);
        }
        try {
            this.zzakE = zzae.zzb(context, this.mSize, this.mColor, this.zzakD);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzakE = SignInButton.zza(context, this.mSize, this.mColor, this.zzakD);
        }
        this.addView(this.zzakE);
        this.zzakE.setEnabled(this.isEnabled());
        this.zzakE.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2, Scope[] scopeArray) {
        zzaf zzaf2 = new zzaf(context);
        zzaf2.zza(context.getResources(), n, n2, scopeArray);
        return zzaf2;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzakF = onClickListener;
        if (this.zzakE != null) {
            this.zzakE.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.zzakE.setEnabled(bl);
    }

    public void onClick(View view) {
        if (this.zzakF != null && view == this.zzakE) {
            this.zzakF.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

