/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzoy;
import com.google.android.gms.internal.zzoz;
import java.lang.ref.WeakReference;

public class zzpe<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaoA = null;
    private zzpe<? extends Result> zzaoB = null;
    private volatile ResultCallbacks<? super R> zzaoC = null;
    private PendingResult<R> zzaoD = null;
    private final Object zzalY = new Object();
    private Status zzaoE = null;
    private final WeakReference<GoogleApiClient> zzama;
    private final zza zzaoF;
    private boolean zzaoG = false;

    public zzpe(WeakReference<GoogleApiClient> weakReference) {
        zzaa.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzama = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzama.get();
        this.zzaoF = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzalY;
        synchronized (object) {
            zzaa.zza((this.zzaoA == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzaa.zza((this.zzaoC == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaoA = resultTransform;
            zzpe<R> zzpe2 = new zzpe<R>(this.zzama);
            this.zzaoB = zzpe2;
            this.zzsI();
            return zzpe2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzalY;
        synchronized (object) {
            zzaa.zza((this.zzaoC == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzaa.zza((this.zzaoA == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaoC = resultCallbacks;
            this.zzsI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.zzalY;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzaoA != null) {
                    zzoy.zzsp().submit(new Runnable((Result)r){
                        final /* synthetic */ Result zzaoH;
                        {
                            this.zzaoH = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zznv.zzalX.set(true);
                                PendingResult pendingResult = zzpe.this.zzaoA.onSuccess(this.zzaoH);
                                zzpe.this.zzaoF.sendMessage(zzpe.this.zzaoF.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzpe.this.zzaoF.sendMessage(zzpe.this.zzaoF.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zznv.zzalX.set(false);
                                zzpe.this.zzd(this.zzaoH);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzpe.this.zzama.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzpe.this);
                                }
                            }
                        }
                    });
                } else if (this.zzsK()) {
                    this.zzaoC.onSuccess(r);
                }
            } else {
                this.zzA(r.getStatus());
                this.zzd((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.zzalY;
        synchronized (object) {
            this.zzaoD = pendingResult;
            this.zzsI();
        }
    }

    private void zzsI() {
        if (this.zzaoA == null && this.zzaoC == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzama.get();
        if (!this.zzaoG && this.zzaoA != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzaoG = true;
        }
        if (this.zzaoE != null) {
            this.zzB(this.zzaoE);
        } else if (this.zzaoD != null) {
            this.zzaoD.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzA(Status status) {
        Object object = this.zzalY;
        synchronized (object) {
            this.zzaoE = status;
            this.zzB(this.zzaoE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzB(Status status) {
        Object object = this.zzalY;
        synchronized (object) {
            if (this.zzaoA != null) {
                Status status2 = this.zzaoA.onFailure(status);
                zzaa.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzA(status2);
            } else if (this.zzsK()) {
                this.zzaoC.onFailure(status);
            }
        }
    }

    void zzsJ() {
        this.zzaoC = null;
    }

    private boolean zzsK() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzama.get();
        return this.zzaoC != null && googleApiClient != null;
    }

    private void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzpe.this.zzalY;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzpe)zzpe.this.zzaoB).zzA(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzoz) {
                            ((zzpe)zzpe.this.zzaoB).zzA(((zzoz)pendingResult).getStatus());
                        } else {
                            zzpe.this.zzaoB.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

